/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.operator;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.operator.AbstractConditionalBinaryOperator;

public class OrOperator
extends AbstractConditionalBinaryOperator {
    public OrOperator(SelectorNode leftOperand, SelectorNode rightOperand) throws InvalidSelectorException {
        super(leftOperand, rightOperand);
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        Boolean leftOperandValue = this.leftOperand.evaluateBoolean(message);
        if (leftOperandValue == null) {
            Boolean rightOperandValue = this.rightOperand.evaluateBoolean(message);
            if (rightOperandValue == null || !rightOperandValue.booleanValue()) {
                return null;
            }
            return Boolean.TRUE;
        }
        if (leftOperandValue.booleanValue()) {
            return Boolean.TRUE;
        }
        return this.rightOperand.evaluateBoolean(message);
    }

    public String toString() {
        return this.parenthesize(this.leftOperand) + " OR " + this.parenthesize(this.rightOperand);
    }
}

