/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message.selector.expression.literal;

import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.expression.AtomicOperand;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.literal.StringLiteral;

public final class StringLiteralList
extends SelectorNode
implements AtomicOperand {
    private SelectorNode[] items;

    public StringLiteralList(SelectorNode[] items) throws InvalidSelectorException {
        this.items = items;
        for (int i = 0; i < items.length; ++i) {
            if (items[i] instanceof StringLiteral) continue;
            throw new InvalidSelectorException("Only string literals are allowed after IN operator");
        }
    }

    @Override
    public Object evaluate(Message message) throws JMSException {
        String[] values = new String[this.items.length];
        for (int n = 0; n < this.items.length; ++n) {
            values[n] = this.items[n].evaluateString(message);
        }
        return values;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int n = 0; n < this.items.length; ++n) {
            if (n > 0) {
                sb.append(",");
            }
            sb.append(String.valueOf(this.items[n]));
        }
        sb.append(")");
        return sb.toString();
    }
}

