/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils.concurrent;

import java.util.LinkedList;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import net.timewalker.ffmq4.utils.concurrent.WaitTimeoutException;

public final class BlockingBoundedFIFO<T> {
    private LinkedList<T> buffer = new LinkedList();
    private Semaphore slots;
    private long timeout;

    public BlockingBoundedFIFO(int maxSize, long timeout) {
        this.slots = new Semaphore(maxSize);
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLast(T value) throws WaitTimeoutException {
        try {
            if (this.timeout >= 0L) {
                if (!this.slots.tryAcquire(this.timeout, TimeUnit.MILLISECONDS)) {
                    throw new WaitTimeoutException();
                }
            } else {
                this.slots.acquire();
            }
        }
        catch (InterruptedException e) {
            throw new WaitTimeoutException();
        }
        LinkedList<T> linkedList = this.buffer;
        synchronized (linkedList) {
            this.buffer.addLast(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T removeFirst() {
        T value;
        LinkedList<T> linkedList = this.buffer;
        synchronized (linkedList) {
            if (this.buffer.isEmpty()) {
                return null;
            }
            value = this.buffer.removeFirst();
        }
        this.slots.release();
        return value;
    }
}

