/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.utils;

public final class FastBitSet {
    private static final int ADDRESS_BITS_PER_WORD = 6;
    private static final int BITS_PER_WORD = 64;
    private long[] words;

    public FastBitSet(int nbits) {
        this.words = new long[FastBitSet.wordIndex(nbits - 1) + 1];
    }

    private static int wordIndex(int bitIndex) {
        return bitIndex >> 6;
    }

    public void ensureCapacity(int requiredBits) {
        int requiredWords = FastBitSet.wordIndex(requiredBits - 1) + 1;
        if (this.words.length < requiredWords) {
            long[] newWords = new long[requiredWords];
            System.arraycopy(this.words, 0, newWords, 0, this.words.length);
            this.words = newWords;
        }
    }

    public boolean flip(int bitIndex) {
        int wordIndex;
        int n = wordIndex = FastBitSet.wordIndex(bitIndex);
        this.words[n] = this.words[n] ^ 1L << bitIndex;
        return (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public void set(int bitIndex) {
        int wordIndex;
        int n = wordIndex = FastBitSet.wordIndex(bitIndex);
        this.words[n] = this.words[n] | 1L << bitIndex;
    }

    public void clear(int bitIndex) {
        int wordIndex;
        int n = wordIndex = FastBitSet.wordIndex(bitIndex);
        this.words[n] = this.words[n] & (1L << bitIndex ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public void clear() {
        for (int i = 0; i < this.words.length; ++i) {
            this.words[i] = 0L;
        }
    }

    public boolean get(int bitIndex) {
        int wordIndex = FastBitSet.wordIndex(bitIndex);
        return (this.words[wordIndex] & 1L << bitIndex) != 0L;
    }

    public int size() {
        return this.words.length * 64;
    }
}

