/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.storage.data.impl.journal;

import java.util.NoSuchElementException;
import net.timewalker.ffmq4.storage.data.impl.journal.AbstractJournalOperation;

public final class JournalQueue {
    private AbstractJournalOperation head;
    private AbstractJournalOperation tail;
    private int size;

    public AbstractJournalOperation getFirst() {
        return this.head;
    }

    public void addLast(AbstractJournalOperation op) {
        if (this.tail == null) {
            this.head = this.tail = op;
        } else {
            this.tail.setNext(op);
            this.tail = op;
        }
        op.setNext(null);
        ++this.size;
    }

    public AbstractJournalOperation removeFirst() {
        AbstractJournalOperation op = this.head;
        if (op == null) {
            throw new NoSuchElementException();
        }
        this.head = op.next();
        if (this.head == null) {
            this.tail = null;
        }
        op.setNext(null);
        --this.size;
        return op;
    }

    public void migrateTo(JournalQueue otherQueue) {
        if (this.head == null) {
            return;
        }
        if (otherQueue.head == null) {
            otherQueue.head = this.head;
            otherQueue.tail = this.tail;
            otherQueue.size = this.size;
        } else {
            otherQueue.tail.setNext(this.head);
            otherQueue.tail = this.tail;
            otherQueue.size += this.size;
        }
        this.tail = null;
        this.head = null;
        this.size = 0;
    }

    public int size() {
        return this.size;
    }
}

