/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.management.destination;

import java.io.File;
import javax.jms.JMSException;
import net.timewalker.ffmq4.management.InvalidDescriptorException;
import net.timewalker.ffmq4.management.destination.DestinationDescriptorMBean;
import net.timewalker.ffmq4.management.destination.definition.AbstractDestinationDefinition;
import net.timewalker.ffmq4.storage.StorageSyncMethod;
import net.timewalker.ffmq4.utils.Settings;
import net.timewalker.ffmq4.utils.StringTools;
import net.timewalker.ffmq4.utils.SystemTools;
import net.timewalker.ffmq4.utils.descriptor.AbstractSettingsBasedDescriptor;

public abstract class AbstractDestinationDescriptor
extends AbstractSettingsBasedDescriptor
implements DestinationDescriptorMBean {
    protected String name;
    protected int initialBlockCount;
    protected int maxBlockCount;
    protected int autoExtendAmount;
    protected int blockSize = 4096;
    protected String rawDataFolder;
    protected File dataFolder;
    protected int maxNonPersistentMessages;
    protected boolean useJournal;
    protected String rawJournalFolder;
    protected File journalFolder;
    protected long maxJournalSize = 0x2000000L;
    protected int maxWriteBatchSize = 1000;
    protected int maxUnflushedJournalSize = 0x400000;
    protected int maxUncommittedStoreSize = 0x1000000;
    protected int journalOutputBuffer = 16384;
    protected boolean temporary;
    protected int storageSyncMethod = 2;
    protected boolean preAllocateFiles;
    protected boolean overflowToPersistent;

    public AbstractDestinationDescriptor() {
    }

    public AbstractDestinationDescriptor(Settings settings) {
        super(settings);
    }

    @Override
    protected void initFromSettings(Settings settings) {
        this.name = settings.getStringProperty("name");
        this.initialBlockCount = settings.getIntProperty("persistentStore.initialBlockCount", 0);
        this.maxBlockCount = settings.getIntProperty("persistentStore.maxBlockCount", 0);
        this.autoExtendAmount = settings.getIntProperty("persistentStore.autoExtendAmount", 0);
        this.blockSize = settings.getIntProperty("persistentStore.blockSize", 4096);
        this.rawDataFolder = settings.getStringProperty("persistentStore.dataFolder", "${FFMQ_BASE}/data", false);
        this.dataFolder = new File(SystemTools.replaceSystemProperties(this.rawDataFolder));
        this.maxNonPersistentMessages = settings.getIntProperty("memoryStore.maxMessages", 0);
        this.useJournal = settings.getBooleanProperty("persistentStore.useJournal", true);
        this.rawJournalFolder = settings.getStringProperty("persistentStore.journal.dataFolder", this.rawDataFolder, false);
        this.journalFolder = new File(SystemTools.replaceSystemProperties(this.rawJournalFolder));
        this.maxJournalSize = settings.getLongProperty("persistentStore.journal.maxFileSize", 0x2000000L);
        this.maxWriteBatchSize = settings.getIntProperty("persistentStore.journal.maxWriteBatchSize", 1000);
        this.maxUnflushedJournalSize = settings.getIntProperty("persistentStore.journal.maxUnflushedJournalSize", 0x400000);
        this.maxUncommittedStoreSize = settings.getIntProperty("persistentStore.journal.maxUncommittedStoreSize", 0x1000000);
        this.journalOutputBuffer = settings.getIntProperty("persistentStore.journal.outputBufferSize", 16384);
        this.temporary = settings.getBooleanProperty("temporary", false);
        this.storageSyncMethod = settings.getIntProperty("persistentStore.syncMethod", 2);
        this.preAllocateFiles = settings.getBooleanProperty("persistentStore.journal.preAllocateFiles", false);
        this.overflowToPersistent = settings.getBooleanProperty("memoryStore.overflowToPersistent", false);
    }

    protected void copyAttributesTo(AbstractDestinationDefinition target) {
        target.rawDataFolder = this.rawDataFolder;
        target.dataFolder = this.dataFolder;
        target.initialBlockCount = this.initialBlockCount;
        target.maxBlockCount = this.maxBlockCount;
        target.autoExtendAmount = this.autoExtendAmount;
        target.blockSize = this.blockSize;
        target.maxNonPersistentMessages = this.maxNonPersistentMessages;
        target.useJournal = this.useJournal;
        target.rawJournalFolder = this.rawJournalFolder;
        target.journalFolder = this.journalFolder;
        target.maxJournalSize = this.maxJournalSize;
        target.maxWriteBatchSize = this.maxWriteBatchSize;
        target.maxUnflushedJournalSize = this.maxUnflushedJournalSize;
        target.maxUncommittedStoreSize = this.maxUncommittedStoreSize;
        target.journalOutputBuffer = this.journalOutputBuffer;
        target.storageSyncMethod = this.storageSyncMethod;
        target.preAllocateFiles = this.preAllocateFiles;
        target.overflowToPersistent = this.overflowToPersistent;
    }

    public final Settings asSettings() {
        Settings settings = new Settings();
        this.fillSettings(settings);
        return settings;
    }

    protected void fillSettings(Settings settings) {
        settings.setStringProperty("name", this.name);
        settings.setIntProperty("persistentStore.initialBlockCount", this.initialBlockCount);
        settings.setIntProperty("persistentStore.maxBlockCount", this.maxBlockCount);
        settings.setIntProperty("persistentStore.autoExtendAmount", this.autoExtendAmount);
        settings.setIntProperty("persistentStore.blockSize", this.blockSize);
        if (this.rawDataFolder != null) {
            settings.setStringProperty("persistentStore.dataFolder", this.rawDataFolder);
        }
        settings.setIntProperty("memoryStore.maxMessages", this.maxNonPersistentMessages);
        settings.setBooleanProperty("persistentStore.useJournal", this.useJournal);
        if (this.rawJournalFolder != null) {
            settings.setStringProperty("persistentStore.journal.dataFolder", this.rawJournalFolder);
        }
        settings.setLongProperty("persistentStore.journal.maxFileSize", this.maxJournalSize);
        settings.setIntProperty("persistentStore.journal.maxWriteBatchSize", this.maxWriteBatchSize);
        settings.setIntProperty("persistentStore.journal.maxUnflushedJournalSize", this.maxUnflushedJournalSize);
        settings.setIntProperty("persistentStore.journal.maxUncommittedStoreSize", this.maxUncommittedStoreSize);
        settings.setIntProperty("persistentStore.journal.outputBufferSize", this.journalOutputBuffer);
        settings.setBooleanProperty("persistentStore.journal.preAllocateFiles", this.preAllocateFiles);
        settings.setIntProperty("persistentStore.syncMethod", this.storageSyncMethod);
        settings.setBooleanProperty("temporary", this.temporary);
        settings.setBooleanProperty("memoryStore.overflowToPersistent", this.overflowToPersistent);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isTemporary() {
        return this.temporary;
    }

    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public int getMaxNonPersistentMessages() {
        return this.maxNonPersistentMessages;
    }

    @Override
    public boolean isUseJournal() {
        return this.useJournal;
    }

    @Override
    public int getInitialBlockCount() {
        return this.initialBlockCount;
    }

    @Override
    public int getBlockSize() {
        return this.blockSize;
    }

    public void setInitialBlockCount(int initialBlockCount) {
        this.initialBlockCount = initialBlockCount;
    }

    public void setMaxBlockCount(int maxBlockCount) {
        this.maxBlockCount = maxBlockCount;
    }

    @Override
    public int getMaxBlockCount() {
        return this.maxBlockCount;
    }

    public void setAutoExtendAmount(int autoExtendAmount) {
        this.autoExtendAmount = autoExtendAmount;
    }

    @Override
    public int getAutoExtendAmount() {
        return this.autoExtendAmount;
    }

    public void setBlockSize(int blockSize) {
        this.blockSize = blockSize;
    }

    public String getRawDataFolder() {
        return this.rawDataFolder;
    }

    public void setRawDataFolder(String rawDataFolder) {
        this.rawDataFolder = rawDataFolder;
    }

    public void setDataFolder(File dataFolder) {
        this.dataFolder = dataFolder;
        this.rawDataFolder = dataFolder != null ? dataFolder.getAbsolutePath() : null;
    }

    public void setUseJournal(boolean useJournal) {
        this.useJournal = useJournal;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setMaxNonPersistentMessages(int maxNonPersistentMessages) {
        this.maxNonPersistentMessages = maxNonPersistentMessages;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
    }

    public String getRawJournalFolder() {
        return this.rawJournalFolder;
    }

    public void setRawJournalFolder(String rawJournalFolder) {
        this.rawJournalFolder = rawJournalFolder;
    }

    public File getJournalFolder() {
        return this.journalFolder;
    }

    public void setJournalFolder(File journalFolder) {
        this.journalFolder = journalFolder;
        this.rawJournalFolder = journalFolder != null ? journalFolder.getAbsolutePath() : null;
    }

    @Override
    public long getMaxJournalSize() {
        return this.maxJournalSize;
    }

    public void setMaxJournalSize(long maxJournalSize) {
        this.maxJournalSize = maxJournalSize;
    }

    @Override
    public int getMaxWriteBatchSize() {
        return this.maxWriteBatchSize;
    }

    public void setMaxWriteBatchSize(int maxWriteBatchSize) {
        this.maxWriteBatchSize = maxWriteBatchSize;
    }

    @Override
    public int getMaxUnflushedJournalSize() {
        return this.maxUnflushedJournalSize;
    }

    public void setMaxUnflushedJournalSize(int maxUnflushedJournalSize) {
        this.maxUnflushedJournalSize = maxUnflushedJournalSize;
    }

    @Override
    public int getMaxUncommittedStoreSize() {
        return this.maxUncommittedStoreSize;
    }

    public void setMaxUncommittedStoreSize(int maxUncommittedStoreSize) {
        this.maxUncommittedStoreSize = maxUncommittedStoreSize;
    }

    @Override
    public int getJournalOutputBuffer() {
        return this.journalOutputBuffer;
    }

    public void setJournalOutputBuffer(int journalOutputBuffer) {
        this.journalOutputBuffer = journalOutputBuffer;
    }

    @Override
    public int getStorageSyncMethod() {
        return this.storageSyncMethod;
    }

    public void setStorageSyncMethod(int storageSyncMethod) {
        this.storageSyncMethod = storageSyncMethod;
    }

    @Override
    public boolean isPreAllocateFiles() {
        return this.preAllocateFiles;
    }

    public void setPreAllocateFiles(boolean preAllocateFiles) {
        this.preAllocateFiles = preAllocateFiles;
    }

    public boolean isOverflowToPersistent() {
        return this.overflowToPersistent;
    }

    public void setOverflowToPersistent(boolean overflowToPersistent) {
        this.overflowToPersistent = overflowToPersistent;
    }

    @Override
    public void check() throws JMSException {
        if (StringTools.isEmpty(this.name)) {
            throw new InvalidDescriptorException("Missing descriptor property : name");
        }
        this.checkMinValue(this.maxNonPersistentMessages, 0L, "maximum non persistent messages");
        this.checkMinValue(this.initialBlockCount, 0L, "initial block count");
        this.checkMinValue(this.maxBlockCount, 0L, "maximum block count");
        if (this.maxBlockCount < this.initialBlockCount) {
            throw new InvalidDescriptorException("Maximum block count should be greater or equal than initial block count");
        }
        if (this.maxBlockCount > 0) {
            if (this.rawDataFolder == null || StringTools.isEmpty(this.rawDataFolder)) {
                throw new InvalidDescriptorException("Missing destination raw data folder");
            }
            if (this.dataFolder == null || StringTools.isEmpty(this.dataFolder.getName())) {
                throw new InvalidDescriptorException("Missing destination data folder");
            }
            if (!this.dataFolder.isDirectory()) {
                throw new InvalidDescriptorException("Invalid data folder : " + this.dataFolder.getAbsolutePath());
            }
            this.checkMinValue(this.blockSize, 1024L, "block size");
            if (this.initialBlockCount != this.maxBlockCount) {
                this.checkMinValue(this.autoExtendAmount, 1L, "auto extend amount");
            }
            if (this.useJournal) {
                if (!this.journalFolder.isDirectory()) {
                    throw new InvalidDescriptorException("Invalid journal folder : " + this.journalFolder.getAbsolutePath());
                }
                this.checkMinValue(this.maxJournalSize, 1024L, "maximum journal size");
                this.checkMinValue(this.maxWriteBatchSize, 1L, "maximum write batch size");
                this.checkMinValue(this.journalOutputBuffer, 1024L, "journal output buffer size");
                this.checkMinValue(this.maxUnflushedJournalSize, 1024L, "maximum unflushed journal size");
                this.checkMinValue(this.maxUncommittedStoreSize, 1024L, "maximum uncommitted store size");
            }
        }
        if (this.initialBlockCount == 0 && this.maxNonPersistentMessages == 0) {
            throw new InvalidDescriptorException("Destination cannot store any message !");
        }
        if (!StorageSyncMethod.isValid(this.storageSyncMethod)) {
            throw new InvalidDescriptorException("Invalid storage sync method : " + this.storageSyncMethod);
        }
    }

    private void checkMinValue(long value, long min, String name) throws InvalidDescriptorException {
        if (value < min) {
            throw new InvalidDescriptorException("Missing or invalid value : " + name + " (" + value + "), should be >= " + min);
        }
    }

    public boolean hasPersistentStore() {
        return this.maxBlockCount > 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(this.name);
        sb.append("] initialBlockCount=");
        sb.append(this.initialBlockCount);
        sb.append(" maxBlockCount=");
        sb.append(this.maxBlockCount);
        sb.append(" autoExtendAmount=");
        sb.append(this.autoExtendAmount);
        sb.append(" blockSize=");
        sb.append(this.blockSize);
        sb.append(" dataFolder=");
        sb.append(this.rawDataFolder);
        sb.append(" maxNonPersistentMessages=");
        sb.append(this.maxNonPersistentMessages);
        sb.append(" useJournal=");
        sb.append(this.useJournal);
        sb.append(" syncMethod=");
        sb.append(this.storageSyncMethod);
        sb.append(" preAllocationFiles=");
        sb.append(this.preAllocateFiles);
        sb.append(" overflowToPersistent=");
        sb.append(this.overflowToPersistent);
        sb.append(" temporary=");
        sb.append(this.temporary);
        return sb.toString();
    }
}

