/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.message;

import java.util.ArrayList;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import net.timewalker.ffmq4.common.message.selector.MessageSelectorParser;
import net.timewalker.ffmq4.common.message.selector.SelectorIndexKey;
import net.timewalker.ffmq4.common.message.selector.expression.Identifier;
import net.timewalker.ffmq4.common.message.selector.expression.SelectorNode;
import net.timewalker.ffmq4.common.message.selector.expression.literal.Literal;
import net.timewalker.ffmq4.common.message.selector.expression.literal.StringLiteral;
import net.timewalker.ffmq4.common.message.selector.expression.literal.StringLiteralList;
import net.timewalker.ffmq4.common.message.selector.expression.operator.AndOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.EqualsOperator;
import net.timewalker.ffmq4.common.message.selector.expression.operator.InOperator;

public final class MessageSelector {
    private SelectorNode selectorTree;

    public MessageSelector(String selectorString) throws JMSException {
        this.selectorTree = new MessageSelectorParser(selectorString).parse();
    }

    public boolean matches(Message message) throws JMSException {
        Boolean result = this.selectorTree != null ? this.selectorTree.evaluateBoolean(message) : null;
        return result != null && result != false;
    }

    public List<SelectorIndexKey> getIndexableKeys() {
        if (this.selectorTree == null) {
            return null;
        }
        return this.findIndexableKeys(this.selectorTree, null);
    }

    private List<SelectorIndexKey> findIndexableKeys(SelectorNode node, List<SelectorIndexKey> keys) {
        InOperator inOperator;
        if (node instanceof EqualsOperator) {
            EqualsOperator eq = (EqualsOperator)node;
            if (eq.leftOperand() instanceof Identifier && eq.rightOperand() instanceof Literal) {
                Identifier id = (Identifier)eq.leftOperand();
                Literal value = (Literal)eq.rightOperand();
                if (keys == null) {
                    keys = new ArrayList<SelectorIndexKey>();
                }
                keys.add(new SelectorIndexKey(id.getName(), value.getValue()));
            } else if (eq.leftOperand() instanceof Literal && eq.rightOperand() instanceof Identifier) {
                Identifier id = (Identifier)eq.rightOperand();
                Literal value = (Literal)eq.leftOperand();
                if (keys == null) {
                    keys = new ArrayList<SelectorIndexKey>();
                }
                keys.add(new SelectorIndexKey(id.getName(), value.getValue()));
            }
        } else if (node instanceof InOperator && (inOperator = (InOperator)node).leftOperand() instanceof Identifier && inOperator.rightOperand() instanceof StringLiteralList) {
            Identifier id = (Identifier)inOperator.leftOperand();
            StringLiteralList valueList = (StringLiteralList)inOperator.rightOperand();
            if (keys == null) {
                keys = new ArrayList<SelectorIndexKey>();
            }
            ArrayList<String> distinctValues = new ArrayList<String>();
            SelectorNode[] items = valueList.getItems();
            for (int n = 0; n < items.length; ++n) {
                String value = ((StringLiteral)items[n]).getValue().toString();
                if (distinctValues.contains(value)) continue;
                distinctValues.add(value);
            }
            Object[] values = distinctValues.toArray(new Object[distinctValues.size()]);
            keys.add(new SelectorIndexKey(id.getName(), values));
        }
        if (node instanceof AndOperator) {
            AndOperator and = (AndOperator)node;
            keys = this.findIndexableKeys(and.leftOperand(), keys);
            keys = this.findIndexableKeys(and.rightOperand(), keys);
        }
        return keys;
    }

    public String toString() {
        return this.selectorTree != null ? this.selectorTree.toString() : "";
    }
}

