/*
 * Decompiled with CFR 0.152.
 */
package net.timewalker.ffmq4.common.destination;

import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import net.timewalker.ffmq4.FFMQException;
import net.timewalker.ffmq4.common.connection.AbstractConnection;
import net.timewalker.ffmq4.common.destination.TemporaryDestination;
import net.timewalker.ffmq4.common.destination.TopicRef;

public final class TemporaryTopicRef
extends TopicRef
implements TemporaryTopic,
TemporaryDestination {
    private static final long serialVersionUID = 1L;
    private transient AbstractConnection connection;

    public TemporaryTopicRef(AbstractConnection connection, String topicName) {
        super(topicName);
        this.connection = connection;
    }

    public void delete() throws JMSException {
        if (this.connection == null) {
            throw new FFMQException("Temporary topic already deleted", "TOPIC_DOES_NOT_EXIST");
        }
        this.connection.deleteTemporaryTopic(this.name);
        this.connection = null;
    }

    @Override
    public String toString() {
        return super.toString() + "[T]";
    }
}

