/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave.converters;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.jbehave.converters.TimeConverter;
import org.jbehave.core.steps.ParameterConverters;
import org.joda.time.LocalTime;

public class TimeListConverter
implements ParameterConverters.ParameterConverter {
    public static final String DEFAULT_LIST_SEPARATOR = ",";
    private final TimeConverter timeConverter = new TimeConverter();
    private final String valueSeparator;

    public TimeListConverter() {
        this(DEFAULT_LIST_SEPARATOR);
    }

    public TimeListConverter(String valueSeparator) {
        this.valueSeparator = valueSeparator;
    }

    public boolean accept(Type type) {
        if (type instanceof ParameterizedType) {
            Type rawType = this.rawType(type);
            Type argumentType = this.argumentType(type);
            return List.class.isAssignableFrom((Class)rawType) && this.timeConverter.accept(argumentType);
        }
        return false;
    }

    public Object convertValue(String value, Type type) {
        Type argumentType = this.argumentType(type);
        List values = ParameterConverters.trim(Arrays.asList(value.split(this.valueSeparator)));
        ArrayList<LocalTime> times = new ArrayList<LocalTime>();
        for (String string : values) {
            times.add((LocalTime)this.timeConverter.convertValue(string, argumentType));
        }
        return times;
    }

    private Type rawType(Type type) {
        return ((ParameterizedType)type).getRawType();
    }

    private Type argumentType(Type type) {
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }
}

