/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.jbehave;

import ch.lambdaj.Lambda;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.jbehave.StoryPathFinder;
import net.thucydides.jbehave.ThucydidesJBehave;
import net.thucydides.jbehave.ThucydidesStepFactory;
import net.thucydides.jbehave.runners.ThucydidesReportingRunner;
import org.codehaus.plexus.util.StringUtils;
import org.jbehave.core.Embeddable;
import org.jbehave.core.io.StoryFinder;
import org.jbehave.core.junit.JUnitStories;
import org.jbehave.core.reporters.Format;
import org.jbehave.core.steps.InjectableStepsFactory;
import org.junit.runner.RunWith;

@RunWith(value=ThucydidesReportingRunner.class)
public class ThucydidesJUnitStories
extends JUnitStories {
    public static final String DEFAULT_STORY_NAME = "**/*.story";
    public static final List<String> DEFAULT_GIVEN_STORY_PREFIX = ImmutableList.of((Object)"Given", (Object)"Precondition");
    private Configuration systemConfiguration;
    private EnvironmentVariables environmentVariables;
    private String storyFolder = "";
    private String storyNamePattern = "**/*.story";
    private org.jbehave.core.configuration.Configuration configuration;
    private List<Format> formats = Arrays.asList(Format.CONSOLE, Format.HTML, Format.XML);

    public ThucydidesJUnitStories() {
    }

    protected ThucydidesJUnitStories(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables.copy();
    }

    protected ThucydidesJUnitStories(Configuration configuration) {
        this.setSystemConfiguration(configuration);
    }

    public EnvironmentVariables getEnvironmentVariables() {
        if (this.environmentVariables == null) {
            this.environmentVariables = ((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get()).copy();
        }
        return this.environmentVariables;
    }

    public org.jbehave.core.configuration.Configuration configuration() {
        if (this.configuration == null) {
            Configuration thucydidesConfiguration = this.getSystemConfiguration();
            if (this.environmentVariables != null) {
                thucydidesConfiguration = thucydidesConfiguration.withEnvironmentVariables(this.environmentVariables);
            }
            this.configuration = ThucydidesJBehave.defaultConfiguration(thucydidesConfiguration, this.formats, (Embeddable)this);
        }
        return this.configuration;
    }

    public InjectableStepsFactory stepsFactory() {
        return ThucydidesStepFactory.withStepsFromPackage(this.getRootPackage(), this.configuration()).andClassLoader(this.getClassLoader());
    }

    public ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }

    public List<String> storyPaths() {
        Set<Object> storyPaths = Sets.newHashSet();
        List<String> pathExpressions = this.getStoryPathExpressions();
        StoryFinder storyFinder = new StoryFinder();
        for (String pathExpression : pathExpressions) {
            if (this.absolutePath(pathExpression)) {
                storyPaths.add(pathExpression);
            }
            for (URL classpathRootUrl : this.allClasspathRoots()) {
                storyPaths.addAll(storyFinder.findPaths(classpathRootUrl, pathExpression, ""));
            }
            storyPaths = this.pruneGivenStoriesFrom((Set<String>)storyPaths);
        }
        return Lists.newArrayList((Iterable)storyPaths);
    }

    private Set<String> pruneGivenStoriesFrom(Set<String> storyPaths) {
        List<Object> filteredPaths = Lists.newArrayList(storyPaths);
        for (String skippedPrecondition : this.skippedPreconditions()) {
            filteredPaths = this.removeFrom(filteredPaths).pathsNotStartingWith(skippedPrecondition).and().pathsNotStartingWith("/" + skippedPrecondition).filter();
        }
        return Sets.newHashSet((Iterable)filteredPaths);
    }

    private FilterBuilder removeFrom(List<String> filteredPaths) {
        return new FilterBuilder(filteredPaths);
    }

    private List<String> skippedPreconditions() {
        return DEFAULT_GIVEN_STORY_PREFIX;
    }

    private boolean absolutePath(String pathExpression) {
        return !pathExpression.contains("*");
    }

    private List<URL> allClasspathRoots() {
        try {
            return Collections.list(this.getClassLoader().getResources("."));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not load the classpath roots when looking for story files", e);
        }
    }

    protected String getRootPackage() {
        return ((Object)((Object)this)).getClass().getPackage().getName();
    }

    protected List<String> getStoryPathExpressions() {
        return Lists.newArrayList((Iterable)Splitter.on((char)';').trimResults().omitEmptyStrings().split((CharSequence)this.getStoryPath()));
    }

    protected String getStoryPath() {
        return StringUtils.isEmpty((String)this.storyFolder) ? this.storyNamePattern : String.valueOf(this.storyFolder) + "/" + this.storyNamePattern;
    }

    public void findStoriesIn(String storyFolder) {
        this.storyFolder = storyFolder;
    }

    public void useFormats(Format ... formats) {
        this.formats = Arrays.asList(formats);
    }

    public void findStoriesCalled(String storyNames) {
        Set<String> storyPathElements = new StoryPathFinder(this.getEnvironmentVariables(), storyNames).findAllElements();
        this.storyNamePattern = Lambda.join(storyPathElements, (String)";");
    }

    protected void setSystemConfiguration(Configuration systemConfiguration) {
        this.systemConfiguration = systemConfiguration;
    }

    protected void setEnvironmentVariables(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public Configuration getSystemConfiguration() {
        if (this.systemConfiguration == null) {
            this.systemConfiguration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
        }
        return this.systemConfiguration;
    }

    protected void useDriver(String driver) {
        this.getSystemConfiguration().setIfUndefined(ThucydidesSystemProperty.DRIVER.getPropertyName(), driver);
    }

    protected void useUniqueSession() {
        this.getSystemConfiguration().setIfUndefined(ThucydidesSystemProperty.THUCYDIDES_USE_UNIQUE_BROWSER.getPropertyName(), "true");
    }

    public ThucydidesConfigurationBuilder runThucydides() {
        return new ThucydidesConfigurationBuilder(this);
    }

    class FilterBuilder {
        private final List<String> paths;

        public FilterBuilder(List<String> paths) {
            this.paths = paths;
        }

        public FilterBuilder pathsNotStartingWith(String skippedPrecondition) {
            ArrayList filteredPaths = Lists.newArrayList();
            for (String path : this.paths) {
                if (this.startsWith(skippedPrecondition, path)) continue;
                filteredPaths.add(path);
            }
            return new FilterBuilder(filteredPaths);
        }

        public FilterBuilder and() {
            return this;
        }

        public List<String> filter() {
            return ImmutableList.copyOf(this.paths);
        }

        private boolean startsWith(String skippedPrecondition, String path) {
            return path.toLowerCase().startsWith(skippedPrecondition.toLowerCase());
        }
    }

    public class ThucydidesConfigurationBuilder {
        private final ThucydidesJUnitStories thucydidesJUnitStories;

        public ThucydidesConfigurationBuilder(ThucydidesJUnitStories thucydidesJUnitStories2) {
            this.thucydidesJUnitStories = thucydidesJUnitStories2;
        }

        public ThucydidesConfigurationBuilder withDriver(String driver) {
            ThucydidesJUnitStories.this.useDriver(driver);
            return this;
        }

        public ThucydidesPropertySetter withProperty(ThucydidesSystemProperty property) {
            return new ThucydidesPropertySetter(this.thucydidesJUnitStories, property);
        }

        public ThucydidesPropertySetter withProperty(String property) {
            return new ThucydidesPropertySetter(this.thucydidesJUnitStories, property);
        }

        public ThucydidesConfigurationBuilder inASingleSession() {
            ThucydidesJUnitStories.this.useUniqueSession();
            return this;
        }
    }

    public class ThucydidesPropertySetter {
        private final ThucydidesJUnitStories thucydidesJUnitStories;
        private final String propertyToSet;

        public ThucydidesPropertySetter(ThucydidesJUnitStories thucydidesJUnitStories2, ThucydidesSystemProperty propertyToSet) {
            this.thucydidesJUnitStories = thucydidesJUnitStories2;
            this.propertyToSet = propertyToSet.getPropertyName();
        }

        public ThucydidesPropertySetter(ThucydidesJUnitStories thucydidesJUnitStories2, String propertyToSet) {
            this.thucydidesJUnitStories = thucydidesJUnitStories2;
            this.propertyToSet = propertyToSet;
        }

        public void setTo(boolean value) {
            this.thucydidesJUnitStories.getSystemConfiguration().setIfUndefined(this.propertyToSet, Boolean.toString(value));
        }

        public void setTo(String value) {
            this.thucydidesJUnitStories.getSystemConfiguration().setIfUndefined(this.propertyToSet, value);
        }

        public void setTo(Integer value) {
            this.thucydidesJUnitStories.getSystemConfiguration().setIfUndefined(this.propertyToSet, Integer.toString(value));
        }
    }
}

