package com.formos.tapestry.testify.internal;

import java.util.Map;

import org.apache.tapestry5.ioc.internal.util.CollectionFactory;


public class ThreadLocalPerTestDataStore implements PerTestDataStore {
    private static class MapHolder extends ThreadLocal<Map<Object,Object>> {
        @Override
        protected Map<Object,Object> initialValue() {
            return CollectionFactory.newMap();
        }
    }

    private final MapHolder holder = new MapHolder();


    private Map<Object,Object> getPerthreadMap() {
        return holder.get();
    }


    public void cleanup() {
        holder.remove();
    }


    public void put(Object key, Object value) {
        getPerthreadMap().put(key, value);
    }


    public Object get(Object key) {
        return getPerthreadMap().get(key);
    }
}
