/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer.ast;

import java.util.function.Predicate;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.InternalApiBridge;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeConversion;
import net.sourceforge.pmd.lang.java.types.internal.infer.ExprMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.MethodCallSite;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.BasePolyMirror;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.JavaExprMirrors;
import net.sourceforge.pmd.lang.java.types.internal.infer.ast.StandaloneExprMirror;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

class ConditionalMirrorImpl
extends BasePolyMirror<ASTConditionalExpression>
implements ExprMirror.BranchingMirror {
    ExprMirror thenBranch;
    ExprMirror elseBranch;
    private final boolean mayBePoly;

    ConditionalMirrorImpl(JavaExprMirrors mirrors, ASTConditionalExpression expr, boolean isStandalone, @Nullable ExprMirror parent, JavaExprMirrors.MirrorMaker subexprMaker) {
        super(mirrors, expr, parent, subexprMaker);
        this.thenBranch = mirrors.getBranchMirrorSubexpression(((ASTConditionalExpression)this.myNode).getThenBranch(), isStandalone, this, subexprMaker);
        this.elseBranch = mirrors.getBranchMirrorSubexpression(((ASTConditionalExpression)this.myNode).getElseBranch(), isStandalone, this, subexprMaker);
        this.mayBePoly = !isStandalone;
    }

    @Override
    public boolean branchesMatch(Predicate<? super ExprMirror> condition) {
        return condition.test(this.thenBranch) && condition.test(this.elseBranch);
    }

    @Override
    public void setStandalone() {
        if (this.mayMutateAst()) {
            InternalApiBridge.setStandaloneTernary((ASTConditionalExpression)this.myNode);
        }
    }

    @Override
    public @Nullable JTypeMirror getStandaloneType() {
        JTypeMirror current = InternalApiBridge.getTypeMirrorInternal((TypeNode)this.myNode);
        if (current != null && (current.unbox().isPrimitive() || !this.mayBePoly)) {
            return current;
        }
        JTypeMirror condType = this.getConditionalStandaloneType(this, (ASTConditionalExpression)this.myNode);
        if (condType != null) {
            InternalApiBridge.setTypeMirrorInternal((TypeNode)this.myNode, condType);
        }
        assert (this.mayBePoly || condType != null) : "This conditional expression is standalone!";
        return condType;
    }

    private JTypeMirror getConditionalStandaloneType(ConditionalMirrorImpl mirror, ASTConditionalExpression cond) {
        @Nullable JTypeMirror thenType = this.standaloneExprTypeInConditional(mirror.thenBranch, cond.getThenBranch());
        if (this.mayBePoly && (thenType == null || !thenType.unbox().isPrimitive())) {
            return null;
        }
        @Nullable JTypeMirror elseType = this.standaloneExprTypeInConditional(mirror.elseBranch, cond.getElseBranch());
        if (this.mayBePoly && (elseType == null || !elseType.unbox().isPrimitive())) {
            return null;
        }
        if (thenType == null || elseType == null) {
            if (thenType == null ^ elseType == null) {
                return thenType == null ? elseType : thenType;
            }
            return this.factory.ts.NULL_TYPE;
        }
        if (elseType.unbox().equals(thenType.unbox())) {
            return thenType.equals(elseType) ? thenType : thenType.unbox();
        }
        if (thenType.isNumeric() && elseType.isNumeric()) {
            return TypeConversion.binaryNumericPromotion(thenType.unbox(), elseType.unbox());
        }
        return TypeConversion.capture(this.factory.ts.lub(CollectionUtil.listOf((Object)thenType.box(), (Object[])new JTypeMirror[]{elseType.box()})));
    }

    private JTypeMirror standaloneExprTypeInConditional(ExprMirror mirror, ASTExpression e) {
        if (mirror instanceof StandaloneExprMirror) {
            return mirror.getStandaloneType();
        }
        if (mirror instanceof ExprMirror.CtorInvocationMirror) {
            return ((ExprMirror.CtorInvocationMirror)mirror).getNewType().unbox();
        }
        if (mirror instanceof ExprMirror.BranchingMirror) {
            return mirror.getStandaloneType();
        }
        if (e instanceof ASTMethodCall) {
            JTypeMirror current = InternalApiBridge.getTypeMirrorInternal(e);
            if (current != null) {
                return current;
            }
            MethodCallSite site = this.factory.infer.newCallSite((ExprMirror.InvocationMirror)mirror, null);
            return this.factory.infer.getCompileTimeDecl(site).getMethodType().getReturnType();
        }
        return null;
    }
}

