/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols.internal.asm;

import java.util.function.Function;
import net.sourceforge.pmd.lang.java.symbols.SymbolicValue;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.ClassStub;
import net.sourceforge.pmd.lang.java.symbols.internal.asm.TypeAnnotationHelper;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.Substitution;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.objectweb.asm.TypePath;

class LazyTypeSig {
    private final String sig;
    private final ClassStub ctx;
    private JTypeMirror parsed;
    private TypeAnnotationHelper.TypeAnnotationSet typeAnnots;

    LazyTypeSig(ClassStub ctx, String descriptor, @Nullable String signature) {
        this.ctx = ctx;
        this.sig = signature == null ? descriptor : signature;
    }

    JTypeMirror get() {
        if (this.parsed == null) {
            this.parsed = this.ctx.sigParser().parseFieldType(this.ctx.getLexicalScope(), this.sig);
            if (this.typeAnnots != null) {
                this.parsed = this.typeAnnots.decorate(this.parsed);
                this.typeAnnots = null;
            }
        }
        return this.parsed;
    }

    JTypeMirror get(Substitution subst) {
        return this.get().subst((Function)subst);
    }

    public String toString() {
        return this.sig;
    }

    public void addTypeAnnotation(@Nullable TypePath path, SymbolicValue.SymAnnot annot) {
        if (this.parsed != null) {
            throw new IllegalStateException("Must add annotations before the field type is parsed.");
        }
        if (this.typeAnnots == null) {
            this.typeAnnots = new TypeAnnotationHelper.TypeAnnotationSet();
        }
        this.typeAnnots.add(path, annot);
    }
}

