/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.documentation;

import java.util.regex.Pattern;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.document.Chars;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;

public class CommentContentRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Pattern> DISSALLOWED_TERMS_DESCRIPTOR = ((PropertyBuilder.RegexPropertyBuilder)PropertyFactory.regexProperty((String)"forbiddenRegex").desc("Illegal terms or phrases")).defaultValue("idiot|jerk").build();

    public CommentContentRule() {
        super(ASTCompilationUnit.class, new Class[0]);
        this.definePropertyDescriptor(DISSALLOWED_TERMS_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTCompilationUnit node, Object data) {
        Pattern pattern = (Pattern)this.getProperty(DISSALLOWED_TERMS_DESCRIPTOR);
        for (JavaComment comment : node.getComments()) {
            this.reportIllegalTerms(this.asCtx(data), comment, pattern, (Node)node);
        }
        return null;
    }

    private void reportIllegalTerms(RuleContext ctx, JavaComment comment, Pattern violationRegex, Node acu) {
        int lineNumber = comment.getReportLocation().getStartLine();
        for (Chars line : comment.getFilteredLines(true)) {
            if (violationRegex.matcher((CharSequence)line).find()) {
                ctx.addViolationWithPosition(acu, lineNumber, lineNumber, "Line matches forbidden content regex ({0})", new Object[]{violationRegex.pattern()});
            }
            ++lineNumber;
        }
    }
}

