/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTBodyDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTFieldDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTLambdaExpression;
import net.sourceforge.pmd.lang.java.ast.ASTVariableDeclaratorId;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.DataflowPass;
import net.sourceforge.pmd.lang.java.rule.internal.JavaPropertyUtil;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SingularFieldRule
extends AbstractJavaRulechainRule {
    private static final Set<String> INVALIDATING_CLASS_ANNOT = CollectionUtil.setOf((Object)"lombok.Builder", (Object[])new String[]{"lombok.EqualsAndHashCode", "lombok.Getter", "lombok.Setter", "lombok.Data", "lombok.Value"});
    private static final PropertyDescriptor<List<String>> IGNORED_FIELD_ANNOTATIONS = JavaPropertyUtil.ignoredAnnotationsDescriptor("lombok.Setter", "lombok.Getter", "java.lang.Deprecated", "lombok.experimental.Delegate", "javafx.fxml.FXML");

    public SingularFieldRule() {
        super(ASTAnyTypeDeclaration.class, new Class[0]);
        this.definePropertyDescriptor(IGNORED_FIELD_ANNOTATIONS);
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        ASTAnyTypeDeclaration enclosingType = (ASTAnyTypeDeclaration)node;
        if (JavaAstUtils.hasAnyAnnotation(enclosingType, INVALIDATING_CLASS_ANNOT)) {
            return null;
        }
        DataflowPass.DataflowResult dataflow = null;
        for (ASTFieldDeclaration fieldDecl : enclosingType.getDeclarations(ASTFieldDeclaration.class)) {
            if (!SingularFieldRule.mayBeSingular(fieldDecl) || JavaAstUtils.hasAnyAnnotation(fieldDecl, (Collection)this.getProperty(IGNORED_FIELD_ANNOTATIONS))) continue;
            for (ASTVariableDeclaratorId varId : fieldDecl.getVarIds()) {
                if (dataflow == null) {
                    dataflow = DataflowPass.getDataflowResult(node.getRoot());
                }
                if (!this.isSingularField(enclosingType, varId, dataflow)) continue;
                this.addViolation(data, (Node)varId, varId.getName());
            }
        }
        return null;
    }

    public static boolean mayBeSingular(AccessNode varId) {
        return varId.getEffectiveVisibility().isAtMost(AccessNode.Visibility.V_PRIVATE) && !varId.getModifiers().hasAny(JModifier.STATIC, JModifier.FINAL);
    }

    private boolean isSingularField(ASTAnyTypeDeclaration fieldOwner, ASTVariableDeclaratorId varId, DataflowPass.DataflowResult dataflow) {
        if (JavaAstUtils.isNeverUsed(varId)) {
            return false;
        }
        HashMap<ASTBodyDeclaration, List> usagesByScope = new HashMap<ASTBodyDeclaration, List>();
        for (ASTAssignableExpr.ASTNamedReferenceExpr usage : varId.getLocalUsages()) {
            if (usage.getEnclosingType() != fieldOwner || !JavaAstUtils.isThisFieldAccess(usage)) {
                return false;
            }
            ASTBodyDeclaration enclosing = this.getEnclosingBodyDecl(fieldOwner, usage);
            if (this.hasEnclosingLambda(enclosing, usage)) {
                return false;
            }
            usagesByScope.computeIfAbsent(enclosing, k -> new ArrayList()).add(usage);
        }
        for (ASTBodyDeclaration method : usagesByScope.keySet()) {
            if (method == null || this.usagesDontObserveValueBeforeMethodCall((List)usagesByScope.get(method), dataflow)) continue;
            return false;
        }
        return true;
    }

    private @Nullable ASTBodyDeclaration getEnclosingBodyDecl(JavaNode stop, ASTAssignableExpr.ASTNamedReferenceExpr usage) {
        return (ASTBodyDeclaration)usage.ancestors().takeWhile(it -> it != stop).first(ASTBodyDeclaration.class);
    }

    private boolean hasEnclosingLambda(JavaNode stop, ASTAssignableExpr.ASTNamedReferenceExpr usage) {
        return usage.ancestors().takeWhile(it -> it != stop).any(it -> it instanceof ASTLambdaExpression);
    }

    private boolean usagesDontObserveValueBeforeMethodCall(List<ASTAssignableExpr.ASTNamedReferenceExpr> usages, DataflowPass.DataflowResult dataflow) {
        for (ASTAssignableExpr.ASTNamedReferenceExpr usage : usages) {
            DataflowPass.ReachingDefinitionSet reaching = dataflow.getReachingDefinitions(usage);
            if (!reaching.containsInitialFieldValue()) continue;
            return false;
        }
        return true;
    }
}

