/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTAnyTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTClassOrInterfaceDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.AccessNode;
import net.sourceforge.pmd.lang.java.ast.JModifier;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class ClassWithOnlyPrivateConstructorsShouldBeFinalRule
extends AbstractJavaRulechainRule {
    public ClassWithOnlyPrivateConstructorsShouldBeFinalRule() {
        super(ASTClassOrInterfaceDeclaration.class, new Class[0]);
    }

    @Override
    public Object visit(ASTClassOrInterfaceDeclaration node, Object data) {
        if (node.isRegularClass() && !node.hasModifiers(JModifier.FINAL, new JModifier[0]) && !node.isAnnotationPresent("lombok.Value") && !this.hasPublicLombokConstructors(node) && this.hasOnlyPrivateCtors(node) && this.hasNoSubclasses(node)) {
            this.asCtx(data).addViolation((Node)node);
        }
        return null;
    }

    private boolean hasPublicLombokConstructors(ASTClassOrInterfaceDeclaration node) {
        return node.getDeclaredAnnotations().filter(it -> TypeTestUtil.isA("lombok.NoArgsConstructor", (TypeNode)it) || TypeTestUtil.isA("lombok.RequiredArgsConstructor", (TypeNode)it) || TypeTestUtil.isA("lombok.AllArgsConstructor", (TypeNode)it)).any(it -> it.getFlatValue("access").filterIs(ASTAssignableExpr.ASTNamedReferenceExpr.class).none(ref -> "PRIVATE".equals(ref.getName())));
    }

    private boolean hasNoSubclasses(ASTClassOrInterfaceDeclaration klass) {
        return klass.getRoot().descendants(ASTAnyTypeDeclaration.class).crossFindBoundaries().none(it -> this.doesExtend((ASTAnyTypeDeclaration)it, klass));
    }

    private boolean doesExtend(ASTAnyTypeDeclaration sub, ASTClassOrInterfaceDeclaration superClass) {
        return sub != superClass && TypeTestUtil.isA((JTypeMirror)superClass.getTypeMirror().getErasure(), (TypeNode)sub);
    }

    private boolean hasOnlyPrivateCtors(ASTClassOrInterfaceDeclaration node) {
        return node.getDeclarations(ASTConstructorDeclaration.class).all(it -> it.getVisibility() == AccessNode.Visibility.V_PRIVATE) && (node.getVisibility() == AccessNode.Visibility.V_PRIVATE || node.getDeclarations(ASTConstructorDeclaration.class).nonEmpty());
    }
}

