/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.metrics.internal;

import java.math.BigInteger;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.java.ast.ASTConditionalExpression;
import net.sourceforge.pmd.lang.java.ast.ASTDoStatement;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTForStatement;
import net.sourceforge.pmd.lang.java.ast.ASTForeachStatement;
import net.sourceforge.pmd.lang.java.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.java.ast.ASTMethodOrConstructorDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.java.ast.ASTStatement;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchArrowBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchExpression;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchFallthroughBranch;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLabel;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchLike;
import net.sourceforge.pmd.lang.java.ast.ASTSwitchStatement;
import net.sourceforge.pmd.lang.java.ast.ASTTryStatement;
import net.sourceforge.pmd.lang.java.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.JavaVisitorBase;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.metrics.internal.CycloVisitor;

public class NpathBaseVisitor
extends JavaVisitorBase<Void, BigInteger> {
    public static final NpathBaseVisitor INSTANCE = new NpathBaseVisitor();

    private BigInteger multiplyChildrenComplexities(JavaNode node) {
        return this.multiplyComplexities((NodeStream<? extends JavaNode>)node.children());
    }

    private BigInteger multiplyComplexities(NodeStream<? extends JavaNode> nodes) {
        return (BigInteger)nodes.reduce((Object)BigInteger.ONE, (acc, n) -> acc.multiply((BigInteger)n.acceptVisitor(this, null)));
    }

    private BigInteger sumChildrenComplexities(JavaNode node, Void data) {
        BigInteger sum = BigInteger.ZERO;
        for (JavaNode child : node.children()) {
            BigInteger childComplexity = (BigInteger)child.acceptVisitor(this, data);
            sum = sum.add(childComplexity);
        }
        return sum;
    }

    @Override
    public BigInteger visitMethodOrCtor(ASTMethodOrConstructorDeclaration node, Void data) {
        return this.multiplyChildrenComplexities(node);
    }

    @Override
    public BigInteger visitJavaNode(JavaNode node, Void data) {
        return this.multiplyChildrenComplexities(node);
    }

    @Override
    public BigInteger visit(ASTIfStatement node, Void data) {
        int boolCompIf = CycloVisitor.booleanExpressionComplexity(node.getCondition());
        BigInteger thenResult = (BigInteger)node.getThenBranch().acceptVisitor(this, data);
        ASTStatement elseBranch = node.getElseBranch();
        BigInteger elseResult = elseBranch != null ? (BigInteger)elseBranch.acceptVisitor(this, data) : BigInteger.ONE;
        return thenResult.add(BigInteger.valueOf(boolCompIf)).add(elseResult);
    }

    @Override
    public BigInteger visit(ASTWhileStatement node, Void data) {
        int boolComp = CycloVisitor.booleanExpressionComplexity(node.getCondition());
        BigInteger nPathBody = (BigInteger)node.getBody().acceptVisitor(this, data);
        return nPathBody.add(BigInteger.valueOf(boolComp + 1));
    }

    @Override
    public BigInteger visit(ASTDoStatement node, Void data) {
        int boolComp = CycloVisitor.booleanExpressionComplexity(node.getCondition());
        BigInteger nPathBody = (BigInteger)node.getBody().acceptVisitor(this, data);
        return nPathBody.add(BigInteger.valueOf(boolComp + 1));
    }

    @Override
    public BigInteger visit(ASTForStatement node, Void data) {
        int boolComp = CycloVisitor.booleanExpressionComplexity(node.getCondition());
        BigInteger nPathBody = (BigInteger)node.getBody().acceptVisitor(this, data);
        return nPathBody.add(BigInteger.valueOf(boolComp + 1));
    }

    @Override
    public BigInteger visit(ASTForeachStatement node, Void data) {
        BigInteger nPathBody = (BigInteger)node.getBody().acceptVisitor(this, data);
        return nPathBody.add(BigInteger.ONE);
    }

    @Override
    public BigInteger visit(ASTReturnStatement node, Void data) {
        ASTExpression expr = node.getExpr();
        if (expr == null) {
            return BigInteger.ONE;
        }
        int boolCompReturn = CycloVisitor.booleanExpressionComplexity(expr);
        BigInteger conditionalExpressionComplexity = this.multiplyChildrenComplexities(expr);
        return conditionalExpressionComplexity.add(BigInteger.valueOf(boolCompReturn));
    }

    @Override
    public BigInteger visit(ASTSwitchExpression node, Void data) {
        return this.handleSwitch(node, data);
    }

    @Override
    public BigInteger visit(ASTSwitchStatement node, Void data) {
        return this.handleSwitch(node, data);
    }

    public BigInteger handleSwitch(ASTSwitchLike node, Void data) {
        int boolCompSwitch = CycloVisitor.booleanExpressionComplexity(node.getTestedExpression());
        BigInteger npath = BigInteger.ZERO;
        int caseRange = 0;
        for (ASTSwitchBranch n : node) {
            BigInteger branchNpath;
            if (n instanceof ASTSwitchFallthroughBranch) {
                caseRange += JavaAstUtils.numAlternatives(n);
                NodeStream<ASTStatement> statements = ((ASTSwitchFallthroughBranch)n).getStatements();
                if (!statements.nonEmpty()) continue;
                branchNpath = this.multiplyComplexities(statements);
                npath = npath.add(branchNpath.multiply(BigInteger.valueOf(caseRange)));
                caseRange = 0;
                continue;
            }
            if (!(n instanceof ASTSwitchArrowBranch)) continue;
            int numAlts = JavaAstUtils.numAlternatives(n);
            branchNpath = (BigInteger)((ASTSwitchArrowBranch)n).getRightHandSide().acceptVisitor(this, data);
            npath = npath.add(branchNpath.multiply(BigInteger.valueOf(numAlts)));
        }
        return npath.add(BigInteger.valueOf(boolCompSwitch));
    }

    @Override
    public BigInteger visit(ASTSwitchLabel node, Void data) {
        if (node.isDefault()) {
            return BigInteger.ONE;
        }
        return BigInteger.valueOf(node.children(ASTExpression.class).count());
    }

    @Override
    public BigInteger visit(ASTConditionalExpression node, Void data) {
        int boolCompTernary = CycloVisitor.booleanExpressionComplexity(node.getCondition());
        return this.sumChildrenComplexities(node, data).add(BigInteger.valueOf(boolCompTernary - 1));
    }

    @Override
    public BigInteger visit(ASTTryStatement node, Void data) {
        return this.sumChildrenComplexities(node, data);
    }
}

