/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.sourceforge.pmd.lang.ast.GenericToken;
import net.sourceforge.pmd.lang.ast.NodeStream;
import net.sourceforge.pmd.lang.ast.impl.javacc.JavaccToken;
import net.sourceforge.pmd.lang.document.FileLocation;
import net.sourceforge.pmd.lang.java.ast.ASTCompilationUnit;
import net.sourceforge.pmd.lang.java.ast.JavaComment;
import net.sourceforge.pmd.lang.java.ast.JavadocComment;
import net.sourceforge.pmd.lang.java.ast.JavadocCommentOwner;
import net.sourceforge.pmd.util.DataMap;
import org.checkerframework.checker.nullness.qual.Nullable;

final class CommentAssignmentPass {
    private static final DataMap.SimpleDataKey<JavadocComment> FORMAL_COMMENT_KEY = DataMap.simpleDataKey((String)"java.comment");

    private CommentAssignmentPass() {
    }

    static @Nullable JavadocComment getComment(JavadocCommentOwner commentOwner) {
        return (JavadocComment)commentOwner.getUserMap().get(FORMAL_COMMENT_KEY);
    }

    private static void setComment(JavadocCommentOwner commentableNode, JavadocComment comment) {
        commentableNode.getUserMap().set(FORMAL_COMMENT_KEY, (Object)comment);
        comment.setOwner(commentableNode);
    }

    public static void assignCommentsToDeclarations(ASTCompilationUnit root) {
        List<JavaComment> comments = root.getComments();
        if (comments.isEmpty()) {
            return;
        }
        block0: for (JavadocCommentOwner commentableNode : CommentAssignmentPass.javadocOwners(root)) {
            JavaccToken firstToken = commentableNode.getFirstToken();
            for (JavaccToken maybeComment : GenericToken.previousSpecials((GenericToken)firstToken)) {
                if (maybeComment.kind != 7) continue;
                JavadocComment comment = new JavadocComment(maybeComment);
                int idx = Collections.binarySearch(comments, comment, Comparator.comparing(JavaComment::getReportLocation, FileLocation.COORDS_COMPARATOR));
                assert (idx >= 0) : "Formal comment not found? " + comment;
                comment = (JavadocComment)comments.get(idx);
                CommentAssignmentPass.setComment(commentableNode, comment);
                continue block0;
            }
        }
    }

    private static NodeStream<JavadocCommentOwner> javadocOwners(ASTCompilationUnit root) {
        return root.descendants().crossFindBoundaries().filterIs(JavadocCommentOwner.class);
    }
}

