/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.ast;

import net.sourceforge.pmd.lang.java.ast.AbstractJavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypingContext;
import net.sourceforge.pmd.lang.java.types.ast.LazyTypeResolver;
import net.sourceforge.pmd.util.AssertionUtil;
import net.sourceforge.pmd.util.ContextedAssertionError;
import org.checkerframework.checker.nullness.qual.NonNull;

abstract class AbstractJavaTypeNode
extends AbstractJavaNode
implements TypeNode {
    private JTypeMirror typeMirror;

    AbstractJavaTypeNode(int i) {
        super(i);
    }

    void forceTypeResolution() {
        this.getTypeMirror();
    }

    <T> T assertNonNullAfterTypeRes(T value) {
        assert (value != null) : "Something went wrong after type resolution of " + this;
        return value;
    }

    @Override
    public @NonNull JTypeMirror getTypeMirror() {
        return this.getTypeMirror(TypingContext.DEFAULT);
    }

    @Override
    public @NonNull JTypeMirror getTypeMirror(TypingContext context) {
        JTypeMirror result;
        if (context.isEmpty() && this.typeMirror != null) {
            return this.typeMirror;
        }
        LazyTypeResolver resolver = this.getRoot().getLazyTypeResolver();
        try {
            result = this.acceptVisitor(resolver, context);
            assert (result != null) : "LazyTypeResolver returned null";
        }
        catch (RuntimeException e) {
            throw AssertionUtil.contexted((RuntimeException)e).addContextValue("Resolving type of", (Object)this);
        }
        catch (AssertionError e) {
            throw (ContextedAssertionError)AssertionUtil.contexted((AssertionError)e).addContextValue("Resolving type of", (Object)this);
        }
        if (context.isEmpty() && this.typeMirror == null) {
            this.typeMirror = result;
        }
        return result;
    }

    JTypeMirror getTypeMirrorInternal() {
        return this.typeMirror;
    }

    void setTypeMirror(JTypeMirror mirror) {
        this.typeMirror = mirror;
    }
}

