/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.performance;

import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTEqualityExpression;
import net.sourceforge.pmd.lang.java.ast.ASTLiteral;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryExpression;
import net.sourceforge.pmd.lang.java.ast.ASTPrimaryPrefix;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRule;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;

public class InefficientEmptyStringCheckRule
extends AbstractJavaRule {
    public InefficientEmptyStringCheckRule() {
        this.addRuleChainVisit(ASTPrimaryExpression.class);
    }

    @Override
    public Object visit(ASTPrimaryExpression node, Object data) {
        if (node.getNumChildren() > 3) {
            String target;
            String lastSuffix = ((JavaNode)node.getChild(node.getNumChildren() - 2)).getImage();
            if (!("isEmpty".equals(lastSuffix) || "length".equals(lastSuffix) && this.isComparisonWithZero(node))) {
                return data;
            }
            TypeNode prevCall = (TypeNode)node.getChild(node.getNumChildren() - 4);
            String string = target = prevCall.getNumChildren() > 0 ? prevCall.getChild(0).getImage() : prevCall.getImage();
            if (target != null && ("trim".equals(target) || target.endsWith(".trim")) && TypeTestUtil.isA(String.class, prevCall)) {
                this.addViolation(data, (Node)node);
            }
        }
        return data;
    }

    private boolean isComparisonWithZero(ASTPrimaryExpression node) {
        if (node.getParent() instanceof ASTEqualityExpression && "==".equals(((JavaNode)node.getParent()).getImage())) {
            JavaNode other = ((JavaNode)node.getParent()).getChild(1);
            if (node.getIndexInParent() == 1) {
                other = ((JavaNode)node.getParent()).getChild(0);
            }
            if (other instanceof ASTPrimaryExpression && other.getNumChildren() == 1 && other.getChild(0) instanceof ASTPrimaryPrefix && other.getChild(0).getNumChildren() == 1 && other.getChild(0).getChild(0) instanceof ASTLiteral) {
                ASTLiteral literal = (ASTLiteral)other.getChild(0).getChild(0);
                return literal.isIntLiteral() && "0".equals(literal.getImage());
            }
        }
        return false;
    }
}

