/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Map;
import java.util.regex.Pattern;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;

public class JsonFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private ObjectMapper formatter;
    private static final Pattern ANY_EOL = Pattern.compile("\\R");
    private Map<String, String> options;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        int indent = Integer.parseInt(options.getOrDefault("indent", "4"));
        String lineEnding = options.getOrDefault("lineending", System.lineSeparator());
        final boolean spaceBeforeSeparator = Boolean.parseBoolean(options.getOrDefault("spaceBeforeSeparator", "true"));
        boolean useAlphabeticalOrder = Boolean.parseBoolean(options.getOrDefault("alphabeticalOrder", "false"));
        DefaultIndenter indenter = new DefaultIndenter(" ".repeat(indent), lineEnding);
        DefaultPrettyPrinter printer = new DefaultPrettyPrinter(){
            private static final long serialVersionUID = 1L;

            public DefaultPrettyPrinter createInstance() {
                this._objectFieldValueSeparatorWithSpaces = (spaceBeforeSeparator ? " " : "") + this._separators.getObjectFieldValueSeparator() + " ";
                return new DefaultPrettyPrinter((DefaultPrettyPrinter)this);
            }
        };
        printer.indentObjectsWith((DefaultPrettyPrinter.Indenter)indenter);
        printer.indentArraysWith((DefaultPrettyPrinter.Indenter)indenter);
        this.formatter = new ObjectMapper();
        this.formatter.setDefaultPrettyPrinter((PrettyPrinter)printer);
        this.formatter.enable(SerializationFeature.INDENT_OUTPUT);
        this.formatter.configure(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS, useAlphabeticalOrder);
        this.options = options;
    }

    @Override
    protected String doFormat(String code, LineEnding ending) throws IOException {
        try (StringWriter stringWriter = new StringWriter();){
            JsonParser jsonParser = this.formatter.createParser(code);
            MappingIterator jsonObjectIterator = this.formatter.readValues(jsonParser, Object.class);
            while (jsonObjectIterator.hasNext()) {
                String jsonString = this.formatter.writer().writeValueAsString(jsonObjectIterator.next());
                stringWriter.write(ANY_EOL.matcher(jsonString.strip()).replaceAll(ending.getChars()));
                stringWriter.write(ending.getChars());
            }
            String formattedCode = stringWriter.toString();
            String string = code.equals(formattedCode) ? null : formattedCode;
            return string;
        }
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }
}

