/*
 * Decompiled with CFR 0.152.
 */
package brave.spring.rabbit;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.internal.Nullable;
import brave.propagation.CurrentTraceContext;
import brave.propagation.TraceContext;
import brave.spring.rabbit.SpringRabbitTracing;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessagePostProcessor;
import org.springframework.amqp.core.MessageProperties;

final class TracingMessagePostProcessor
implements MessagePostProcessor {
    final SpringRabbitTracing springRabbitTracing;
    final Tracing tracing;
    final Tracer tracer;
    final CurrentTraceContext currentTraceContext;
    final TraceContext.Injector<MessageProperties> injector;
    @Nullable
    final String remoteServiceName;

    TracingMessagePostProcessor(SpringRabbitTracing springRabbitTracing) {
        this.springRabbitTracing = springRabbitTracing;
        this.tracing = springRabbitTracing.tracing;
        this.tracer = this.tracing.tracer();
        this.currentTraceContext = this.tracing.currentTraceContext();
        this.injector = springRabbitTracing.injector;
        this.remoteServiceName = springRabbitTracing.remoteServiceName;
    }

    public Message postProcessMessage(Message message) {
        TraceContext maybeParent = this.currentTraceContext.get();
        Span span = maybeParent == null ? this.tracer.nextSpan(this.springRabbitTracing.extractAndClearHeaders(message)) : this.tracer.newChild(maybeParent);
        if (!span.isNoop()) {
            span.kind(Span.Kind.PRODUCER).name("publish");
            if (this.remoteServiceName != null) {
                span.remoteServiceName(this.remoteServiceName);
            }
            long timestamp = this.tracing.clock(span.context()).currentTimeMicroseconds();
            span.start(timestamp).finish(timestamp);
        }
        this.injector.inject(span.context(), (Object)message.getMessageProperties());
        return message;
    }
}

