/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.AbstractClasspathDirectory;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.eclipse.jdt.internal.compiler.batch.CompilationUnit;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.ICompilationUnit;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class SourcepathDirectory
extends AbstractClasspathDirectory {
    private final String encoding;

    private SourcepathDirectory(File directory, Charset encoding) {
        super(directory);
        this.encoding = encoding != null ? encoding.name() : null;
    }

    @Override
    protected NameEnvironmentAnswer findType0(String packageName, String typeName, AccessRestriction accessRestriction) throws IOException, ClassFormatException {
        File javaFile = this.getFile(packageName, typeName, ".java");
        if (javaFile != null) {
            ClasspathCompilationUnit cu = new ClasspathCompilationUnit(javaFile, this.encoding);
            return new NameEnvironmentAnswer((ICompilationUnit)cu, accessRestriction);
        }
        return null;
    }

    public String toString() {
        return "Sourcepath for directory " + this.file;
    }

    public static SourcepathDirectory create(File directory, Charset encoding) {
        return new SourcepathDirectory(directory, encoding);
    }

    public static class ClasspathCompilationUnit
    extends CompilationUnit {
        public ClasspathCompilationUnit(File file, String encoding) {
            super(null, file.getAbsolutePath(), encoding, null, false);
        }
    }
}

