/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.io.requestbody;

import com.fasterxml.jackson.databind.node.ObjectNode;
import io.smallrye.openapi.runtime.io.JsonUtil;
import io.smallrye.openapi.runtime.io.content.ContentWriter;
import io.smallrye.openapi.runtime.io.extension.ExtensionWriter;
import io.smallrye.openapi.runtime.util.StringUtil;
import java.util.Map;
import org.eclipse.microprofile.openapi.models.parameters.RequestBody;

public class RequestBodyWriter {
    private RequestBodyWriter() {
    }

    public static void writeRequestBodies(ObjectNode parent, Map<String, RequestBody> requestBodies) {
        if (requestBodies == null) {
            return;
        }
        ObjectNode requestBodiesNode = parent.putObject("requestBodies");
        for (Map.Entry<String, RequestBody> entry : requestBodies.entrySet()) {
            RequestBodyWriter.writeRequestBody(requestBodiesNode, entry.getValue(), entry.getKey());
        }
    }

    public static void writeRequestBody(ObjectNode parent, RequestBody model) {
        RequestBodyWriter.writeRequestBody(parent, model, "requestBody");
    }

    private static void writeRequestBody(ObjectNode parent, RequestBody model, String name) {
        if (model == null) {
            return;
        }
        ObjectNode node = parent.putObject(name);
        if (StringUtil.isNotEmpty(model.getRef())) {
            JsonUtil.stringProperty(node, "$ref", model.getRef());
        } else {
            JsonUtil.stringProperty(node, "description", model.getDescription());
            ContentWriter.writeContent(node, model.getContent());
            JsonUtil.booleanProperty(node, "required", model.getRequired());
            ExtensionWriter.writeExtensions(node, model);
        }
    }
}

