/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.methods;

import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodDescriptor;
import io.smallrye.mutiny.vertx.codegen.methods.MutinyMethodGenerator;
import io.smallrye.mutiny.vertx.codegen.methods.UniMethodGenerator;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.MethodInfo;
import io.vertx.codegen.ParamInfo;
import io.vertx.codegen.type.TypeInfo;
import io.vertx.codegen.type.VoidTypeInfo;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ForgetMethodGenerator
extends MutinyMethodGenerator {
    public static final String SUFFIX_AND_FORGET = "AndForget";

    public ForgetMethodGenerator(PrintWriter writer) {
        super(writer);
    }

    public void generate(ClassModel model, MethodInfo method) {
        MutinyMethodDescriptor forgetMethod = this.computeMethodInfo(model, method);
        this.generateJavadoc(forgetMethod);
        this.generateMethodDeclaration(forgetMethod);
        this.generateBody(forgetMethod);
        this.writer.println();
    }

    public void generateDeclaration(ClassModel model, MethodInfo method) {
        MutinyMethodDescriptor forgetMethod = this.computeMethodInfo(model, method);
        this.generateJavadoc(forgetMethod);
        this.generateMethodDeclaration(forgetMethod);
        this.writer.println(";");
        this.writer.println();
    }

    public void generateOther(ClassModel model, MethodInfo method) {
        MutinyMethodDescriptor forgetMethod = this.computeMethodInfoOther(model, method);
        this.generateJavadoc(forgetMethod);
        this.generateMethodDeclaration(forgetMethod);
        this.generateBodyOther(forgetMethod);
        this.writer.println();
    }

    private void generateBody(MutinyMethodDescriptor forgetMethod) {
        this.writer.println(" { ");
        this.writer.print("    " + forgetMethod.getOriginalMethodName());
        this.writer.print("(");
        List params = forgetMethod.getMethod().getParams();
        this.writer.print(params.stream().map(ParamInfo::getName).collect(Collectors.joining(", ")));
        this.writer.println(").subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);");
        if (forgetMethod.isFluent()) {
            this.writer.println("    return this;");
        }
        this.writer.println("  }");
    }

    private void generateBodyOther(MutinyMethodDescriptor forgetMethod) {
        this.writer.println(" { ");
        this.writer.print("    " + forgetMethod.getOriginalMethodName() + "(");
        List names = forgetMethod.getMethod().getParams().stream().map(ParamInfo::getName).collect(Collectors.toList());
        this.writer.print(String.join((CharSequence)", ", names));
        this.writer.print(").subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);\n");
        if (forgetMethod.isFluent()) {
            this.writer.print("    return this;\n");
        }
        this.writer.println("  }");
        this.writer.println("");
    }

    private MutinyMethodDescriptor computeMethodInfoOther(ClassModel model, MethodInfo method) {
        MethodInfo newMethod = method.copy().setReturnType(VoidTypeInfo.INSTANCE).setName(method.getName() + SUFFIX_AND_FORGET);
        Optional<TypeInfo> fluentType = this.getFluentType(model, method.getName());
        boolean fluent = false;
        if (fluentType.isPresent()) {
            fluent = true;
            newMethod.setReturnType(fluentType.get());
        }
        return MutinyMethodDescriptor.createAndForgetMethod(newMethod, method, fluent);
    }

    private MutinyMethodDescriptor computeMethodInfo(ClassModel model, MethodInfo method) {
        ArrayList<ParamInfo> params = new ArrayList<ParamInfo>(method.getParams());
        TypeInfo returnType = VoidTypeInfo.INSTANCE;
        Optional<TypeInfo> fluentType = this.getFluentType(model, method.getName());
        boolean fluent = false;
        if (fluentType.isPresent()) {
            fluent = true;
            returnType = fluentType.get();
        }
        params.remove(method.getParams().size() - 1);
        List<ParamInfo> paramInfos = UniMethodGenerator.updateParamInfoIfNeeded(params);
        return MutinyMethodDescriptor.createAndForgetMethod(method.copy().setName(method.getName() + SUFFIX_AND_FORGET).setReturnType(returnType).setParams(paramInfos), method, fluent);
    }

    private Optional<TypeInfo> getFluentType(ClassModel model, String name) {
        return model.getMethods().stream().filter(m -> m.getName().equalsIgnoreCase(name) && m.isFluent()).map(MethodInfo::getReturnType).findFirst();
    }
}

