package io.vertx.mutiny.core.streams;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * Pipe data from a {@link io.vertx.mutiny.core.streams.ReadStream} to a {@link io.vertx.mutiny.core.streams.WriteStream} and performs flow control where necessary to
 * prevent the write stream buffer from getting overfull.
 * <p>
 * Instances of this class read items from a {@link io.vertx.mutiny.core.streams.ReadStream} and write them to a {@link io.vertx.mutiny.core.streams.WriteStream}. If data
 * can be read faster than it can be written this could result in the write queue of the {@link io.vertx.mutiny.core.streams.WriteStream} growing
 * without bound, eventually causing it to exhaust all available RAM.
 * <p>
 * To prevent this, after each write, instances of this class check whether the write queue of the {@link io.vertx.mutiny.core.streams.WriteStream} is full, and if so, the {@link io.vertx.mutiny.core.streams.ReadStream} is paused, and a <code>drainHandler</code> is set on the
 * {@link io.vertx.mutiny.core.streams.WriteStream}.
 * <p>
 * When the {@link io.vertx.mutiny.core.streams.WriteStream} has processed half of its backlog, the <code>drainHandler</code> will be
 * called, which results in the pump resuming the {@link io.vertx.mutiny.core.streams.ReadStream}.
 * <p>
 * This class can be used to pipe from any {@link io.vertx.mutiny.core.streams.ReadStream} to any {@link io.vertx.mutiny.core.streams.WriteStream},
 * e.g. from an {@link io.vertx.mutiny.core.http.HttpServerRequest} to an {@link io.vertx.mutiny.core.file.AsyncFile},
 * or from {@link io.vertx.mutiny.core.net.NetSocket} to a {@link io.vertx.mutiny.core.http.WebSocket}.
 * <p>
 * Please see the documentation for more information.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.streams.Pipe original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.streams.Pipe.class)
public class Pipe<T> implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Pipe> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Pipe((io.vertx.core.streams.Pipe) obj),
    Pipe::getDelegate
  );

  private final io.vertx.core.streams.Pipe<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public Pipe(io.vertx.core.streams.Pipe delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public Pipe(Object delegate, TypeArg<T> typeArg_0) {
    this.delegate = (io.vertx.core.streams.Pipe)delegate;
    this.__typeArg_0 = typeArg_0;
  }

  public Pipe(io.vertx.core.streams.Pipe delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Pipe() {
    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  @Override
  public io.vertx.core.streams.Pipe getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Pipe that = (Pipe) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param end <code>true</code> to end the stream on a source <code>ReadStream</code> failure
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.streams.Pipe<T> endOnFailure(boolean end) { 
    delegate.endOnFailure(end);
    return this;
  }

  /**
   * @param end <code>true</code> to end the stream on a source <code>ReadStream</code> success
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.streams.Pipe<T> endOnSuccess(boolean end) { 
    delegate.endOnSuccess(end);
    return this;
  }

  /**
   * @param end <code>true</code> to end the stream on a source <code>ReadStream</code> completion
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.streams.Pipe<T> endOnComplete(boolean end) { 
    delegate.endOnComplete(end);
    return this;
  }

  /**
   * Start to pipe the elements to the destination <code>WriteStream</code>.
   * <p>
   * When the operation fails with a write error, the source stream is resumed.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param dst the destination write stream
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> to(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(completionHandler -> {
        delegate.to(dst.getDelegate(), completionHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.Pipe#to(io.vertx.mutiny.core.streams.WriteStream)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param dst the destination write stream
   * @return the Void instance produced by the operation.
   */
  public Void toAndAwait(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    return (Void) to(dst).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.Pipe#to(io.vertx.mutiny.core.streams.WriteStream)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.Pipe#to(io.vertx.mutiny.core.streams.WriteStream)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.Pipe#to(io.vertx.mutiny.core.streams.WriteStream)} but you don't need to compose it with other operations.
   * @param dst the destination write stream
   */
  public void toAndForget(io.vertx.mutiny.core.streams.WriteStream<T> dst) { 
    to(dst).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   */
  public void close() { 
    delegate.close();
  }

  public static <T>Pipe<T> newInstance(io.vertx.core.streams.Pipe arg) {
    return arg != null ? new Pipe<T>(arg) : null;
  }


  public static <T>Pipe<T> newInstance(io.vertx.core.streams.Pipe arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new Pipe<T>(arg, __typeArg_T) : null;
  }

}
