package io.vertx.mutiny.core.net;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.net.SSLOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * A TCP client.
 * <p>
 * Multiple connections to different servers can be made using the same instance.
 * <p>
 * This client supports a configurable number of connection attempts and a configurable
 * delay between attempts.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.net.NetClient original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.net.NetClient.class)
public class NetClient implements io.smallrye.mutiny.vertx.MutinyDelegate, io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<NetClient> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new NetClient((io.vertx.core.net.NetClient) obj),
    NetClient::getDelegate
  );

  private final io.vertx.core.net.NetClient delegate;
  
  public NetClient(io.vertx.core.net.NetClient delegate) {
    this.delegate = delegate;
  }

  public NetClient(Object delegate) {
    this.delegate = (io.vertx.core.net.NetClient)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  NetClient() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.net.NetClient getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    NetClient that = (NetClient) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port
   * @param host the host
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.net.NetSocket> connect(int port, String host) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(connectHandler -> {
        delegate.connect(port, host, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(connectHandler, ar -> ar.map(event -> io.vertx.mutiny.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetClient#connect(int,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port
   * @param host the host
   * @return the NetSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.net.NetSocket connectAndAwait(int port, String host) { 
    return (io.vertx.mutiny.core.net.NetSocket) connect(port, host).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetClient#connect(int,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetClient#connect(int,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetClient#connect(int,String)} but you don't need to compose it with other operations.
   * @param port the port
   * @param host the host
   * @return the instance of NetClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetClient connectAndForget(int port, String host) { 
    connect(port, host).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>port</code> and <code>host</code>.
   * <p>
   * <code>host</code> can be a valid host name or IP address. The connect is done asynchronously and on success, a
   * {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.net.NetSocket> connect(int port, String host, String serverName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(connectHandler -> {
        delegate.connect(port, host, serverName, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(connectHandler, ar -> ar.map(event -> io.vertx.mutiny.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetClient#connect(int,String,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return the NetSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.net.NetSocket connectAndAwait(int port, String host, String serverName) { 
    return (io.vertx.mutiny.core.net.NetSocket) connect(port, host, serverName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetClient#connect(int,String,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetClient#connect(int,String,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetClient#connect(int,String,String)} but you don't need to compose it with other operations.
   * @param port the port
   * @param host the host
   * @param serverName the SNI server name
   * @return the instance of NetClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetClient connectAndForget(int port, String host, String serverName) { 
    connect(port, host, serverName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param remoteAddress the remote address
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.net.NetSocket> connect(io.vertx.mutiny.core.net.SocketAddress remoteAddress) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(connectHandler -> {
        delegate.connect(remoteAddress.getDelegate(), io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(connectHandler, ar -> ar.map(event -> io.vertx.mutiny.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetClient#connect(io.vertx.mutiny.core.net.SocketAddress)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param remoteAddress the remote address
   * @return the NetSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.net.NetSocket connectAndAwait(io.vertx.mutiny.core.net.SocketAddress remoteAddress) { 
    return (io.vertx.mutiny.core.net.NetSocket) connect(remoteAddress).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetClient#connect(io.vertx.mutiny.core.net.SocketAddress)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetClient#connect(io.vertx.mutiny.core.net.SocketAddress)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetClient#connect(io.vertx.mutiny.core.net.SocketAddress)} but you don't need to compose it with other operations.
   * @param remoteAddress the remote address
   * @return the instance of NetClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetClient connectAndForget(io.vertx.mutiny.core.net.SocketAddress remoteAddress) { 
    connect(remoteAddress).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Open a connection to a server at the specific <code>remoteAddress</code>.
   * <p>
   * The connect is done asynchronously and on success, a {@link io.vertx.mutiny.core.net.NetSocket} instance is supplied via the <code>connectHandler</code> instance
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<io.vertx.mutiny.core.net.NetSocket> connect(io.vertx.mutiny.core.net.SocketAddress remoteAddress, String serverName) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(connectHandler -> {
        delegate.connect(remoteAddress.getDelegate(), serverName, io.smallrye.mutiny.vertx.MutinyHelper.convertHandler(connectHandler, ar -> ar.map(event -> io.vertx.mutiny.core.net.NetSocket.newInstance((io.vertx.core.net.NetSocket)event))));
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetClient#connect(io.vertx.mutiny.core.net.SocketAddress,String)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return the NetSocket instance produced by the operation.
   */
  public io.vertx.mutiny.core.net.NetSocket connectAndAwait(io.vertx.mutiny.core.net.SocketAddress remoteAddress, String serverName) { 
    return (io.vertx.mutiny.core.net.NetSocket) connect(remoteAddress, serverName).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetClient#connect(io.vertx.mutiny.core.net.SocketAddress,String)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetClient#connect(io.vertx.mutiny.core.net.SocketAddress,String)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetClient#connect(io.vertx.mutiny.core.net.SocketAddress,String)} but you don't need to compose it with other operations.
   * @param remoteAddress the remote address
   * @param serverName the SNI server name
   * @return the instance of NetClient to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.net.NetClient connectAndForget(io.vertx.mutiny.core.net.SocketAddress remoteAddress, String serverName) { 
    connect(remoteAddress, serverName).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
    return this;
  }

  /**
   * Close the client.
   * <p>
   * Any sockets which have not been closed manually will be closed here. The close is asynchronous and may not
   * complete until some time after the method has returned.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetClient#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetClient#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetClient#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetClient#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the new SSL options
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.updateSSLOptions(options, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions(SSLOptions)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the new SSL options
   * @return the Boolean instance produced by the operation.
   */
  public Boolean updateSSLOptionsAndAwait(io.vertx.core.net.SSLOptions options) { 
    return (Boolean) updateSSLOptions(options).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions(SSLOptions)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions(SSLOptions)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions(SSLOptions)} but you don't need to compose it with other operations.
   * @param options the new SSL options
   */
  public void updateSSLOptionsAndForget(io.vertx.core.net.SSLOptions options) { 
    updateSSLOptions(options).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions}  but supplying a handler that will be called when the update
   * happened (or has failed).
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  @CheckReturnValue
  public io.smallrye.mutiny.Uni<Boolean> updateSSLOptions(io.vertx.core.net.SSLOptions options, boolean force) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.updateSSLOptions(options, force, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions(SSLOptions,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param options the new SSL options
   * @param force force the update when options are equals
   * @return the Boolean instance produced by the operation.
   */
  public Boolean updateSSLOptionsAndAwait(io.vertx.core.net.SSLOptions options, boolean force) { 
    return (Boolean) updateSSLOptions(options, force).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions(SSLOptions,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions(SSLOptions,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.net.NetClient#updateSSLOptions(SSLOptions,boolean)} but you don't need to compose it with other operations.
   * @param options the new SSL options
   * @param force force the update when options are equals
   */
  public void updateSSLOptionsAndForget(io.vertx.core.net.SSLOptions options, boolean force) { 
    updateSSLOptions(options, force).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  NetClient newInstance(io.vertx.core.net.NetClient arg) {
    return arg != null ? new NetClient(arg) : null;
  }

}
