package io.vertx.mutiny.core.http;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.smallrye.common.annotation.CheckReturnValue;
import io.vertx.core.http.CookieSameSite;

/**
 * Represents an HTTP Cookie.
 * <p>
 * All cookies must have a name and a value and can optionally have other fields set such as path, domain, etc.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.http.Cookie original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.http.Cookie.class)
public class Cookie implements io.smallrye.mutiny.vertx.MutinyDelegate {

  public static final io.smallrye.mutiny.vertx.TypeArg<Cookie> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new Cookie((io.vertx.core.http.Cookie) obj),
    Cookie::getDelegate
  );

  private final io.vertx.core.http.Cookie delegate;
  
  public Cookie(io.vertx.core.http.Cookie delegate) {
    this.delegate = delegate;
  }

  public Cookie(Object delegate) {
    this.delegate = (io.vertx.core.http.Cookie)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  Cookie() {
    this.delegate = null;
  }

  @Override
  public io.vertx.core.http.Cookie getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    Cookie that = (Cookie) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @param name the name of the cookie
   * @param value the cookie value
   * @return the cookie
   */
  public static io.vertx.mutiny.core.http.Cookie cookie(String name, String value) { 
    io.vertx.mutiny.core.http.Cookie ret = io.vertx.mutiny.core.http.Cookie.newInstance((io.vertx.core.http.Cookie)io.vertx.core.http.Cookie.cookie(name, value));
    return ret;
  }

  /**
   * @return the name of this cookie
   */
  public String getName() { 
    String ret = delegate.getName();
    return ret;
  }

  /**
   * @return the value of this cookie
   */
  public String getValue() { 
    String ret = delegate.getValue();
    return ret;
  }

  /**
   * @param value The value to set
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.Cookie setValue(String value) { 
    delegate.setValue(value);
    return this;
  }

  /**
   * @param domain The domain to use
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.Cookie setDomain(String domain) { 
    delegate.setDomain(domain);
    return this;
  }

  /**
   * @return the domain for the cookie
   */
  public String getDomain() { 
    String ret = delegate.getDomain();
    return ret;
  }

  /**
   * @param path The path to use for this cookie
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.Cookie setPath(String path) { 
    delegate.setPath(path);
    return this;
  }

  /**
   * @return the path for this cookie
   */
  public String getPath() { 
    String ret = delegate.getPath();
    return ret;
  }

  /**
   * @param maxAge The maximum age of this cookie in seconds
   * @return the instance of Cookie to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.Cookie setMaxAge(long maxAge) { 
    delegate.setMaxAge(maxAge);
    return this;
  }

  /**
   * @return the maxAge of this cookie
   */
  public long getMaxAge() { 
    long ret = delegate.getMaxAge();
    return ret;
  }

  /**
   * @param secure True if this cookie is to be secure, otherwise false
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.Cookie setSecure(boolean secure) { 
    delegate.setSecure(secure);
    return this;
  }

  /**
   * @return the security status of this cookie
   */
  public boolean isSecure() { 
    boolean ret = delegate.isSecure();
    return ret;
  }

  /**
   * @param httpOnly True if the cookie is HTTP only, otherwise false.
   * @return the instance of Cookie to chain method calls.
   */
  @Fluent
  public io.vertx.mutiny.core.http.Cookie setHttpOnly(boolean httpOnly) { 
    delegate.setHttpOnly(httpOnly);
    return this;
  }

  /**
   * @return the http only status of this cookie
   */
  public boolean isHttpOnly() { 
    boolean ret = delegate.isHttpOnly();
    return ret;
  }

  /**
   * @param policy The policy should be one of {@link io.vertx.core.http.CookieSameSite}.
   * @return a reference to this, so the API can be used fluently
   */
  @Fluent
  public io.vertx.mutiny.core.http.Cookie setSameSite(io.vertx.core.http.CookieSameSite policy) { 
    delegate.setSameSite(policy);
    return this;
  }

  /**
   * @return the SameSite policy of this cookie
   */
  public io.vertx.core.http.CookieSameSite getSameSite() { 
    io.vertx.core.http.CookieSameSite ret = delegate.getSameSite();
    return ret;
  }

  /**
   * @return the encoded cookie
   */
  public String encode() { 
    String ret = delegate.encode();
    return ret;
  }

  public static  Cookie newInstance(io.vertx.core.http.Cookie arg) {
    return arg != null ? new Cookie(arg) : null;
  }

}
