package io.vertx.mutiny.core;

import java.util.Map;
import java.util.stream.Collectors;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.smallrye.mutiny.vertx.TypeArg;
import io.vertx.codegen.annotations.Fluent;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Future;

/**
 * An executor for executing blocking code in Vert.x .<p>
 *
 * It provides the same <code>executeBlocking</code> operation than {@link io.vertx.mutiny.core.Context} and
 * {@link io.vertx.mutiny.core.Vertx} but on a separate worker pool.<p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.WorkerExecutor original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.WorkerExecutor.class)
public class WorkerExecutor implements io.vertx.mutiny.core.metrics.Measured {

  public static final io.smallrye.mutiny.vertx.TypeArg<WorkerExecutor> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new WorkerExecutor((io.vertx.core.WorkerExecutor) obj),
    WorkerExecutor::getDelegate
  );

  private final io.vertx.core.WorkerExecutor delegate;
  
  public WorkerExecutor(io.vertx.core.WorkerExecutor delegate) {
    this.delegate = delegate;
  }

  public WorkerExecutor(Object delegate) {
    this.delegate = (io.vertx.core.WorkerExecutor)delegate;
  }

  /**
   * Empty constructor used by CDI, do not use this constructor directly.
   **/
  WorkerExecutor() {
    this.delegate = null;
  }

  public io.vertx.core.WorkerExecutor getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WorkerExecutor that = (WorkerExecutor) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  /**
   * @return <code>true</code> if metrics are enabled
   */
  public boolean isMetricsEnabled() { 
    boolean ret = delegate.isMetricsEnabled();
    return ret;
  }

  /**
   * Safely execute some blocking code.
   * <p>
   * Executes the blocking code in the handler <code>blockingCodeHandler</code> using a thread from the worker pool.
   * <p>
   * When the code is complete the handler <code>resultHandler</code> will be called with the result on the original context
   * (i.e. on the original event loop of the caller).
   * <p>
   * A <code>Future</code> instance is passed into <code>blockingCodeHandler</code>. When the blocking code successfully completes,
   * the handler should call the {@link io.vertx.mutiny.core.Promise#complete} or {@link io.vertx.mutiny.core.Promise#complete} method, or the {@link io.vertx.mutiny.core.Promise#fail}
   * method if it failed.
   * <p>
   * In the <code>blockingCodeHandler</code> the current context remains the original context and therefore any task
   * scheduled in the <code>blockingCodeHandler</code> will be executed on the this context and not on the worker thread.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <T> io.smallrye.mutiny.Uni<T> executeBlocking(io.smallrye.mutiny.Uni<T> blockingCodeHandler, boolean ordered) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
          public void handle(io.vertx.core.Promise<T> event) {
            blockingCodeHandler.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
          }
      }, ordered, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Consumer<Promise<T>>,boolean)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   * @return the T instance produced by the operation.
   */
  public <T> T executeBlockingAndAwait(io.smallrye.mutiny.Uni<T> blockingCodeHandler, boolean ordered) { 
    return (T) executeBlocking(blockingCodeHandler, ordered).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Consumer<Promise<T>>,boolean)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Consumer<Promise<T>>,boolean)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Consumer<Promise<T>>,boolean)} but you don't need to compose it with other operations.
   * @param blockingCodeHandler handler representing the blocking code to run
   * @param ordered if true then if executeBlocking is called several times on the same context, the executions for that context will be executed serially, not in parallel. if false then they will be no ordering guarantees
   */
  public <T> void executeBlockingAndForget(io.smallrye.mutiny.Uni<T> blockingCodeHandler, boolean ordered) { 
    executeBlocking(blockingCodeHandler, ordered).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Like {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking} called with ordered = true.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param blockingCodeHandler 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public <T> io.smallrye.mutiny.Uni<T> executeBlocking(io.smallrye.mutiny.Uni<T> blockingCodeHandler) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(resultHandler -> {
        delegate.executeBlocking(new Handler<io.vertx.core.Promise<T>>() {
          public void handle(io.vertx.core.Promise<T> event) {
            blockingCodeHandler.subscribe().with(it -> event.complete(it), failure -> event.fail(failure));
          }
      }, resultHandler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Consumer<Promise<T>>)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param blockingCodeHandler 
   * @return the T instance produced by the operation.
   */
  public <T> T executeBlockingAndAwait(io.smallrye.mutiny.Uni<T> blockingCodeHandler) { 
    return (T) executeBlocking(blockingCodeHandler).await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Consumer<Promise<T>>)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Consumer<Promise<T>>)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.WorkerExecutor#executeBlocking(Consumer<Promise<T>>)} but you don't need to compose it with other operations.
   * @param blockingCodeHandler 
   */
  public <T> void executeBlockingAndForget(io.smallrye.mutiny.Uni<T> blockingCodeHandler) { 
    executeBlocking(blockingCodeHandler).subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  /**
   * Close the executor.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public io.smallrye.mutiny.Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
        delegate.close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.WorkerExecutor#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation.
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.WorkerExecutor#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.WorkerExecutor#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.WorkerExecutor#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    close().subscribe().with(io.smallrye.mutiny.vertx.UniHelper.NOOP);
  }

  public static  WorkerExecutor newInstance(io.vertx.core.WorkerExecutor arg) {
    return arg != null ? new WorkerExecutor(arg) : null;
  }

}
