package io.vertx.mutiny.core.eventbus;

import java.util.Map;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import java.util.function.Consumer;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Publisher;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * Represents a stream of message that can be written to.
 * <p>
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.core.eventbus.MessageProducer original} non Mutiny-ified interface using Vert.x codegen.
 */

@io.smallrye.mutiny.vertx.MutinyGen(io.vertx.core.eventbus.MessageProducer.class)
public class MessageProducer<T> implements io.vertx.mutiny.core.streams.WriteStream<T> {

  public static final io.smallrye.mutiny.vertx.TypeArg<MessageProducer> __TYPE_ARG = new io.smallrye.mutiny.vertx.TypeArg<>(    obj -> new MessageProducer((io.vertx.core.eventbus.MessageProducer) obj),
    MessageProducer::getDelegate
  );

  private final io.vertx.core.eventbus.MessageProducer<T> delegate;
  public final io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_0;
  
  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate) {
    this.delegate = delegate;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public MessageProducer(io.vertx.core.eventbus.MessageProducer delegate, io.smallrye.mutiny.vertx.TypeArg<T> typeArg_0) {
    this.delegate = delegate;
    this.__typeArg_0 = typeArg_0;
  }

  /**
  * Empty constructor used by CDI, do not use this constructor directly.
  **/
  MessageProducer() {    this.delegate = null;
    this.__typeArg_0 = io.smallrye.mutiny.vertx.TypeArg.unknown();  }

  public io.vertx.core.eventbus.MessageProducer getDelegate() {
    return delegate;
  }

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MessageProducer that = (MessageProducer) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  private io.smallrye.mutiny.vertx.WriteStreamSubscriber<T> subscriber;

  public synchronized io.smallrye.mutiny.vertx.WriteStreamSubscriber<T> toSubscriber() {
    if (subscriber == null) {
      java.util.function.Function<T, T> conv = (java.util.function.Function<T, T>) __typeArg_0.unwrap;
      subscriber = io.smallrye.mutiny.vertx.MutinyHelper.toSubscriber(getDelegate(), conv);
    }
    return subscriber;
  }

  /**
   * @param data 
   * @param handler 
   */
  private void __end(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.end(__typeArg_0.<T>unwrap(data), handler);
  }

  /**
   * Same as  but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param data 
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end(T data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(data, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(T)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param data 
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait(T data) { 
    return (Void) end(data).await().indefinitely();
  }

  /**
   * @return true if write queue is full
   */
  public boolean writeQueueFull() { 
    boolean ret = delegate.writeQueueFull();
    return ret;
  }

  /**
   * @param message the message to send
   * @param replyHandler reply handler will be called when any reply from the recipient is received, may be <code>null</code>
   * @return reference to this for fluency
   */
  @Deprecated
  private <R> io.vertx.mutiny.core.eventbus.MessageProducer<T> __send(T message, Handler<AsyncResult<io.vertx.mutiny.core.eventbus.Message<R>>> replyHandler) { 
    io.vertx.mutiny.core.eventbus.MessageProducer<T> ret = io.vertx.mutiny.core.eventbus.MessageProducer.newInstance(delegate.send(__typeArg_0.<T>unwrap(message), new Handler<AsyncResult<io.vertx.core.eventbus.Message<R>>>() {
      public void handle(AsyncResult<io.vertx.core.eventbus.Message<R>> ar) {
        if (ar.succeeded()) {
          replyHandler.handle(io.vertx.core.Future.succeededFuture(io.vertx.mutiny.core.eventbus.Message.newInstance(ar.result(), io.smallrye.mutiny.vertx.TypeArg.unknown())));
        } else {
          replyHandler.handle(io.vertx.core.Future.failedFuture(ar.cause()));
        }
      }
    }), __typeArg_0);
    return ret;
  }

  /**
   * Like {@link io.vertx.mutiny.core.eventbus.MessageProducer#send} but specifying a <code>replyHandler</code> that will be called if the recipient
   * subsequently replies to the message.
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @param message the message to send
   * @return reference to this for fluency
   */
  @Deprecated
  public <R> Uni<io.vertx.mutiny.core.eventbus.Message<R>> send(T message) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __send(message, handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.MessageProducer#send(T)}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @param message the message to send
   * @return reference to this for fluency
   */
  @Deprecated
  public <R> io.vertx.mutiny.core.eventbus.Message<R> sendAndAwait(T message) { 
    return (io.vertx.mutiny.core.eventbus.Message<R>) send(message).await().indefinitely();
  }

  private io.vertx.mutiny.core.eventbus.MessageProducer<T> __exceptionHandler(Handler<Throwable> handler) { 
    delegate.exceptionHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageProducer<T> exceptionHandler(Consumer<Throwable> handler) {
    return __exceptionHandler(handler != null ? handler::accept : null);
  }

  private io.vertx.mutiny.core.eventbus.MessageProducer<T> __write(T data, Handler<AsyncResult<Void>> handler) { 
    delegate.write(__typeArg_0.<T>unwrap(data), handler);
    return this;
  }

  public Uni<Void> write(T data) { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __write(data, handler);
    });
  }

  public Void writeAndAwait(T data) { 
    return (Void) write(data).await().indefinitely();
  }

  public io.vertx.mutiny.core.eventbus.MessageProducer<T> setWriteQueueMaxSize(int maxSize) { 
    delegate.setWriteQueueMaxSize(maxSize);
    return this;
  }

  private io.vertx.mutiny.core.eventbus.MessageProducer<T> __drainHandler(Handler<Void> handler) { 
    delegate.drainHandler(handler);
    return this;
  }

  public io.vertx.mutiny.core.eventbus.MessageProducer<T> drainHandler(Consumer<Void> handler) {
    return __drainHandler(handler != null ? handler::accept : null);
  }

  /**
   * @param options the new options
   * @return this producer object
   */
  public io.vertx.mutiny.core.eventbus.MessageProducer<T> deliveryOptions(DeliveryOptions options) { 
    delegate.deliveryOptions(options);
    return this;
  }

  /**
   * @return The address to which the producer produces messages.
   */
  public String address() { 
    String ret = delegate.address();
    return ret;
  }

  /**
   * @param handler 
   */
  private void __end(Handler<AsyncResult<Void>> handler) { 
    delegate.end(handler);
  }

  /**
   * Closes the producer, calls {@link io.vertx.mutiny.core.eventbus.MessageProducer#close}
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> end() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __end(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.streams.WriteStream#end}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void endAndAwait() { 
    return (Void) end().await().indefinitely();
  }

  /**
   * @param handler 
   */
  private void __close(Handler<AsyncResult<Void>> handler) { 
    delegate.close(handler);
  }

  /**
   * Same as {@link io.vertx.mutiny.core.eventbus.MessageProducer#close} but with an <code>handler</code> called when the operation completes
   * <p>
   * Unlike the <em>bare</em> Vert.x variant, this method returns a {@link io.smallrye.mutiny.Uni Uni}.
   * Don't forget to <em>subscribe</em> on it to trigger the operation.
   * @return the {@link io.smallrye.mutiny.Uni uni} firing the result of the operation when completed, or a failure if the operation failed.
   */
  public Uni<Void> close() { 
    return io.smallrye.mutiny.vertx.AsyncResultUni.toUni(handler -> {
      __close(handler);
    });
  }

  /**
   * Blocking variant of {@link io.vertx.mutiny.core.eventbus.MessageProducer#close}.
   * <p>
   * This method waits for the completion of the underlying asynchronous operation.
   * If the operation completes successfully, the result is returned, otherwise the failure is thrown (potentially wrapped in a RuntimeException).
   * @return the Void instance produced by the operation
   */
  public Void closeAndAwait() { 
    return (Void) close().await().indefinitely();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end(T)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end(T)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end(T)} but you don't need to compose it with other operations.
   * @param data the data to write
   */
  public void endAndForget(T data) { 
    delegate.end(__typeArg_0.<T>unwrap(data));
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.eventbus.MessageProducer#send(T)} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.eventbus.MessageProducer#send(T)}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.eventbus.MessageProducer#send(T)} but you don't need to compose it with other operations.
   * @param message the message to send
   * @return reference to this for fluency
   */
  @Deprecated
  public io.vertx.mutiny.core.eventbus.MessageProducer<T> sendAndForget(T message) { 
    io.vertx.mutiny.core.eventbus.MessageProducer<T> ret = io.vertx.mutiny.core.eventbus.MessageProducer.newInstance(delegate.send(__typeArg_0.<T>unwrap(message)), __typeArg_0);
    return ret;
  }

  public io.vertx.mutiny.core.eventbus.MessageProducer<T> writeAndForget(T data) { 
    delegate.write(__typeArg_0.<T>unwrap(data));
    return this;
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.streams.WriteStream#end} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.streams.WriteStream#end}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.streams.WriteStream#end} but you don't need to compose it with other operations.
   */
  public void endAndForget() { 
    delegate.end();
  }

  /**
   * Variant of {@link io.vertx.mutiny.core.eventbus.MessageProducer#close} that ignores the result of the operation.
   * <p>
   * This method subscribes on the result of {@link io.vertx.mutiny.core.eventbus.MessageProducer#close}, but discards the outcome (item or failure).
   * This method is useful to trigger the asynchronous operation from {@link io.vertx.mutiny.core.eventbus.MessageProducer#close} but you don't need to compose it with other operations.
   */
  public void closeAndForget() { 
    delegate.close();
  }

  public static final int DEFAULT_WRITE_QUEUE_MAX_SIZE = io.vertx.core.eventbus.MessageProducer.DEFAULT_WRITE_QUEUE_MAX_SIZE;
  public static <T>MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg) {
    return arg != null ? new MessageProducer<T>(arg) : null;
  }


  public static <T>MessageProducer<T> newInstance(io.vertx.core.eventbus.MessageProducer arg, io.smallrye.mutiny.vertx.TypeArg<T> __typeArg_T) {
    return arg != null ? new MessageProducer<T>(arg, __typeArg_T) : null;
  }

}
