/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.multi;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.multi.AbstractMultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import java.util.Comparator;

public final class MultiSkipRepetitionsOp<T>
extends AbstractMultiOperator<T, T> {
    private final Comparator<? super T> comparator;

    public MultiSkipRepetitionsOp(Multi<T> upstream) {
        this(upstream, null);
    }

    public MultiSkipRepetitionsOp(Multi<T> upstream, Comparator<? super T> comparator) {
        super(upstream);
        this.comparator = comparator;
    }

    @Override
    public void subscribe(MultiSubscriber<? super T> subscriber) {
        ParameterValidation.nonNullNpe(subscriber, "subscriber");
        this.upstream.subscribe().withSubscriber(new MultiSkipRepetitionsProcessor<T>(subscriber, this.comparator));
    }

    static final class MultiSkipRepetitionsProcessor<T>
    extends MultiOperatorProcessor<T, T> {
        private final Comparator<? super T> comparator;
        private T last;

        public MultiSkipRepetitionsProcessor(MultiSubscriber<? super T> subscriber, Comparator<? super T> comparator) {
            super(subscriber);
            this.comparator = comparator == null ? (a, b) -> a.equals(b) ? 0 : 1 : comparator;
        }

        @Override
        public void onItem(T t) {
            if (this.isDone()) {
                return;
            }
            try {
                if (this.last == null || this.comparator.compare(this.last, t) != 0) {
                    this.last = t;
                    this.downstream.onItem(t);
                } else {
                    this.request(1L);
                }
            }
            catch (Exception e) {
                this.onFailure(e);
            }
        }

        @Override
        public void onFailure(Throwable t) {
            super.onFailure(t);
            this.last = null;
        }

        @Override
        public void onCompletion() {
            super.onCompletion();
            this.last = null;
        }

        @Override
        public void cancel() {
            super.cancel();
            this.last = null;
        }
    }
}

