/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.context;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.UniInterceptor;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.Executor;
import org.eclipse.microprofile.context.ThreadContext;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;

public class ContextPropagationUniInterceptor
implements UniInterceptor {
    static final ThreadContext THREAD_CONTEXT = ContextManagerProvider.instance().getContextManager().newThreadContextBuilder().build();

    public <T> UniSubscriber<? super T> onSubscription(Uni<T> instance, final UniSubscriber<? super T> subscriber) {
        final Executor executor = THREAD_CONTEXT.currentContextExecutor();
        return new UniSubscriber<T>(){

            public void onSubscribe(UniSubscription subscription) {
                executor.execute(() -> subscriber.onSubscribe(subscription));
            }

            public void onItem(T item) {
                executor.execute(() -> subscriber.onItem(item));
            }

            public void onFailure(Throwable failure) {
                executor.execute(() -> subscriber.onFailure(failure));
            }
        };
    }

    public <T> Uni<T> onUniCreation(final Uni<T> uni) {
        final Executor executor = THREAD_CONTEXT.currentContextExecutor();
        return new AbstractUni<T>(){

            protected void subscribing(UniSerializedSubscriber<? super T> subscriber) {
                executor.execute(() -> AbstractUni.subscribe((Uni)uni, (UniSubscriber)subscriber));
            }
        };
    }
}

