/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jandex;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.DotName;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;

public final class ClassType
extends Type {
    public static final ClassType OBJECT_TYPE = new ClassType(DotName.OBJECT_NAME);
    public static final ClassType STRING_TYPE = new ClassType(DotName.STRING_NAME);
    public static final ClassType CLASS_TYPE = new ClassType(DotName.CLASS_NAME);
    public static final ClassType ANNOTATION_TYPE = new ClassType(DotName.ANNOTATION_NAME);
    public static final ClassType BYTE_CLASS = new ClassType(DotName.BYTE_CLASS_NAME);
    public static final ClassType CHARACTER_CLASS = new ClassType(DotName.CHARACTER_CLASS_NAME);
    public static final ClassType DOUBLE_CLASS = new ClassType(DotName.DOUBLE_CLASS_NAME);
    public static final ClassType FLOAT_CLASS = new ClassType(DotName.FLOAT_CLASS_NAME);
    public static final ClassType INTEGER_CLASS = new ClassType(DotName.INTEGER_CLASS_NAME);
    public static final ClassType LONG_CLASS = new ClassType(DotName.LONG_CLASS_NAME);
    public static final ClassType SHORT_CLASS = new ClassType(DotName.SHORT_CLASS_NAME);
    public static final ClassType BOOLEAN_CLASS = new ClassType(DotName.BOOLEAN_CLASS_NAME);
    public static final ClassType VOID_CLASS = new ClassType(DotName.VOID_CLASS_NAME);
    private static final Map<DotName, ClassType> KNOWN_TYPES;

    public static ClassType create(DotName name) {
        ClassType known = KNOWN_TYPES.get(name);
        return known != null ? known : new ClassType(name);
    }

    static ClassType create(DotName name, AnnotationInstance[] annotations) {
        if (annotations == null || annotations.length == 0) {
            return ClassType.create(name);
        }
        return new ClassType(name, annotations);
    }

    public static ClassType create(String name) {
        return ClassType.create(DotName.createSimple(name));
    }

    public static ClassType create(Class<?> clazz) {
        return ClassType.create(DotName.createSimple(clazz.getName()));
    }

    public static Builder builder(DotName name) {
        return new Builder(name);
    }

    public static Builder builder(Class<?> clazz) {
        return ClassType.builder(DotName.createSimple(clazz.getName()));
    }

    private ClassType(DotName name) {
        this(name, null);
    }

    private ClassType(DotName name, AnnotationInstance[] annotations) {
        super(name, annotations);
    }

    @Override
    public Type.Kind kind() {
        return Type.Kind.CLASS;
    }

    @Override
    public ClassType asClassType() {
        return this;
    }

    @Override
    Type copyType(AnnotationInstance[] newAnnotations) {
        return ClassType.create(this.name(), newAnnotations);
    }

    ParameterizedType toParameterizedType() {
        return new ParameterizedType(this.name(), null, null, this.annotationArray());
    }

    static {
        HashMap<DotName, ClassType> map = new HashMap<DotName, ClassType>();
        map.put(DotName.OBJECT_NAME, OBJECT_TYPE);
        map.put(DotName.STRING_NAME, STRING_TYPE);
        map.put(DotName.CLASS_NAME, CLASS_TYPE);
        map.put(DotName.ANNOTATION_NAME, ANNOTATION_TYPE);
        map.put(DotName.BYTE_CLASS_NAME, BYTE_CLASS);
        map.put(DotName.CHARACTER_CLASS_NAME, CHARACTER_CLASS);
        map.put(DotName.DOUBLE_CLASS_NAME, DOUBLE_CLASS);
        map.put(DotName.FLOAT_CLASS_NAME, FLOAT_CLASS);
        map.put(DotName.INTEGER_CLASS_NAME, INTEGER_CLASS);
        map.put(DotName.LONG_CLASS_NAME, LONG_CLASS);
        map.put(DotName.SHORT_CLASS_NAME, SHORT_CLASS);
        map.put(DotName.BOOLEAN_CLASS_NAME, BOOLEAN_CLASS);
        map.put(DotName.VOID_CLASS_NAME, VOID_CLASS);
        KNOWN_TYPES = Collections.unmodifiableMap(map);
    }

    public static final class Builder
    extends Type.Builder<Builder> {
        Builder(DotName name) {
            super(name);
        }

        public ClassType build() {
            return ClassType.create(this.name, this.annotationsArray());
        }
    }
}

