/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.processor.generation.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.server.processor.ScannedApplication;
import org.jboss.resteasy.reactive.server.processor.generation.filters.FilterGeneration;
import org.jboss.resteasy.reactive.server.processor.scanning.FeatureScanner;
import org.jboss.resteasy.reactive.server.processor.util.GeneratedClass;

public class FilterFeature
implements FeatureScanner {
    final Set<DotName> unwrappableTypes;
    final Set<String> additionalBeanAnnotations;

    public FilterFeature(Set<DotName> unwrappableTypes, Set<String> additionalBeanAnnotations) {
        this.unwrappableTypes = unwrappableTypes;
        this.additionalBeanAnnotations = additionalBeanAnnotations;
    }

    @Override
    public FeatureScanner.FeatureScanResult integrate(IndexView application, ScannedApplication scannedApplication) {
        ArrayList<GeneratedClass> generatedClasses = new ArrayList<GeneratedClass>();
        List<FilterGeneration.GeneratedFilter> result = FilterGeneration.generate(application, this.unwrappableTypes, this.additionalBeanAnnotations);
        for (FilterGeneration.GeneratedFilter i : result) {
            ResourceInterceptor request;
            generatedClasses.addAll(i.getGeneratedClasses());
            if (i.isRequestFilter()) {
                request = scannedApplication.getResourceInterceptors().getContainerRequestFilters().create();
                request.setClassName(i.generatedClassName);
                request.setPriority(i.priority);
                request.setNonBlockingRequired(i.nonBlocking);
                request.setNameBindingNames(i.nameBindingNames);
                if (i.isPreMatching()) {
                    scannedApplication.getResourceInterceptors().getContainerRequestFilters().addPreMatchInterceptor(request);
                    continue;
                }
                if (!i.getNameBindingNames().isEmpty()) {
                    scannedApplication.getResourceInterceptors().getContainerRequestFilters().addNameRequestInterceptor(request);
                    continue;
                }
                scannedApplication.getResourceInterceptors().getContainerRequestFilters().addGlobalRequestInterceptor(request);
                continue;
            }
            request = scannedApplication.getResourceInterceptors().getContainerResponseFilters().create();
            request.setClassName(i.generatedClassName);
            request.setPriority(i.priority);
            request.setNameBindingNames(i.nameBindingNames);
            if (!i.getNameBindingNames().isEmpty()) {
                scannedApplication.getResourceInterceptors().getContainerResponseFilters().addNameRequestInterceptor(request);
                continue;
            }
            scannedApplication.getResourceInterceptors().getContainerResponseFilters().addGlobalRequestInterceptor(request);
        }
        return new FeatureScanner.FeatureScanResult(generatedClasses);
    }
}

