/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.jsonb;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.inject.Inject;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbException;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.common.providers.serialisers.AbstractJsonMessageBodyReader;
import org.jboss.resteasy.reactive.common.util.StreamUtil;
import org.jboss.resteasy.reactive.server.spi.ResteasyReactiveResourceInfo;
import org.jboss.resteasy.reactive.server.spi.ServerMessageBodyReader;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public class JsonbMessageBodyReader
extends AbstractJsonMessageBodyReader
implements ServerMessageBodyReader<Object> {
    private final Jsonb json;

    @Inject
    public JsonbMessageBodyReader(Jsonb json) {
        this.json = json;
    }

    public Object readFrom(Class<Object> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.doReadFrom(type, genericType, entityStream);
    }

    public Object readFrom(Class<Object> type, Type genericType, MediaType mediaType, ServerRequestContext context) throws WebApplicationException, IOException {
        return this.doReadFrom(type, genericType, context.getInputStream());
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    public boolean isReadable(Class<?> type, Type genericType, ResteasyReactiveResourceInfo lazyMethod, MediaType mediaType) {
        return this.isReadable(mediaType, type);
    }

    private Object doReadFrom(Class<Object> type, Type genericType, InputStream entityStream) {
        if (StreamUtil.isEmpty((InputStream)entityStream)) {
            return null;
        }
        try {
            return this.json.fromJson(entityStream, genericType != null ? genericType : type);
        }
        catch (JsonbException e) {
            if (this.isEmptyInputException((Exception)((Object)e))) {
                return null;
            }
            throw e;
        }
    }

    private boolean isEmptyInputException(Exception e) {
        return e.getMessage().contains("Invalid token=EOF at (line no=1, column no=0");
    }
}

