/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import java.net.URI;

public class JavaElementUriBuilder {
    public static final String QUTE_JAVA_SCHEME = "qute-java";
    public static final String QUTE_JAVA_URI_PREFIX = "qute-java://";
    private final String typeName;
    private String method;
    private String annotation;

    private JavaElementUriBuilder(String typeName) {
        this.typeName = typeName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getMethod() {
        return this.method;
    }

    public JavaElementUriBuilder setMethod(String method) {
        this.method = method;
        return this;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public JavaElementUriBuilder setAnnotation(String annotation) {
        this.annotation = annotation;
        return this;
    }

    public static JavaElementUriBuilder builder(String typeName) {
        return new JavaElementUriBuilder(typeName);
    }

    public URI build() {
        StringBuilder uri = new StringBuilder(QUTE_JAVA_URI_PREFIX);
        uri.append(this.typeName);
        if (this.method != null) {
            uri.append("#").append(this.method);
        }
        if (this.annotation != null) {
            uri.append("@").append(this.annotation);
        }
        return URI.create(uri.toString());
    }

    public static boolean isJavaUri(URI uri) {
        return uri != null && QUTE_JAVA_SCHEME.equals(uri.getScheme());
    }

    public static boolean isJavaUri(String uri) {
        return uri != null && uri.startsWith(QUTE_JAVA_URI_PREFIX);
    }
}

