/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute;

import io.quarkus.qute.TraceManager;
import io.quarkus.qute.trace.ResolveEvent;
import io.quarkus.qute.trace.TemplateEvent;
import io.quarkus.qute.trace.TraceListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class TraceManagerImpl
implements TraceManager {
    private final List<TraceListener> listeners = new CopyOnWriteArrayList<TraceListener>();

    TraceManagerImpl() {
    }

    @Override
    public void addTraceListener(TraceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeTraceListener(TraceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        this.listeners.remove(listener);
    }

    void fireStartTemplate(TemplateEvent event) {
        if (this.hasTraceListeners()) {
            for (TraceListener listener : this.listeners) {
                listener.onStartTemplate(event);
            }
        }
    }

    void fireBeforeResolveEvent(ResolveEvent event) {
        if (this.hasTraceListeners()) {
            for (TraceListener listener : this.listeners) {
                listener.onBeforeResolve(event);
            }
        }
    }

    void fireAfterResolveEvent(ResolveEvent event) {
        if (this.hasTraceListeners()) {
            for (TraceListener listener : this.listeners) {
                listener.onAfterResolve(event);
            }
        }
    }

    void fireEndTemplate(TemplateEvent event) {
        if (this.hasTraceListeners()) {
            for (TraceListener listener : this.listeners) {
                listener.onEndTemplate(event);
            }
        }
    }

    @Override
    public boolean hasTraceListeners() {
        return !this.listeners.isEmpty();
    }
}

