/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.qute.trace;

import io.quarkus.qute.Engine;

public abstract class BaseEvent {
    private final Engine engine;
    private final long startTime;
    private volatile long endTime = -1L;

    public BaseEvent(Engine engine) {
        this.engine = engine;
        this.startTime = System.nanoTime();
    }

    public Engine getEngine() {
        return this.engine;
    }

    public void done() {
        this.endTime = System.nanoTime();
    }

    public long getEllapsedTime() {
        if (this.endTime == -1L) {
            return -1L;
        }
        return this.endTime - this.startTime;
    }
}

