/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.http.deployment.devmode.console;

import io.quarkus.deployment.ide.Ide;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;

public class OpenIdeHandler
extends DevConsolePostHandler {
    private static final Logger log = Logger.getLogger(OpenIdeHandler.class);
    private static final Map<String, String> LANG_TO_EXT = Map.of("java", "java", "kotlin", "kt");
    private final Ide ide;

    public OpenIdeHandler(Ide ide) {
        this.ide = ide;
    }

    protected void dispatch(RoutingContext routingContext, MultiMap form) {
        String className = form.get("className");
        String lang = form.get("lang");
        String line = form.get("line");
        if (this.isNullOrEmpty(className) || this.isNullOrEmpty(lang)) {
            routingContext.fail(400);
        }
        if (this.ide != null) {
            this.typicalProcessLaunch(routingContext, className, lang, line, this.ide);
        } else {
            log.debug((Object)("Unhandled IDE : " + this.ide));
            routingContext.fail(500);
        }
    }

    private void typicalProcessLaunch(RoutingContext routingContext, String className, String lang, String line, Ide ide) {
        String fileName = this.toFileName(className, lang);
        if (fileName == null) {
            routingContext.fail(404);
            return;
        }
        List args = ide.createFileOpeningArgs(fileName, line);
        this.launchInIDE(routingContext, ide, args);
    }

    private String toFileName(String className, String lang) {
        String fileName;
        Path sourceFile;
        String effectiveClassName = className;
        int dollarIndex = className.indexOf("$");
        if (dollarIndex > -1) {
            effectiveClassName = className.substring(0, dollarIndex);
        }
        if ((sourceFile = Ide.findSourceFile((String)(fileName = effectiveClassName.replace('.', File.separatorChar) + "." + LANG_TO_EXT.get(lang)))) == null) {
            return null;
        }
        return sourceFile.toAbsolutePath().toString();
    }

    protected void launchInIDE(final RoutingContext routingContext, final Ide ide, final List<String> args) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    String effectiveCommand = ide.getEffectiveCommand();
                    if (OpenIdeHandler.this.isNullOrEmpty(effectiveCommand)) {
                        log.debug((Object)("Unable to determine proper launch command for IDE: " + ide));
                        routingContext.response().setStatusCode(500).end();
                        return;
                    }
                    ArrayList<String> command = new ArrayList<String>();
                    command.add(effectiveCommand);
                    command.addAll(args);
                    new ProcessBuilder(command).inheritIO().start().waitFor(10L, TimeUnit.SECONDS);
                    routingContext.response().setStatusCode(200).end();
                }
                catch (Exception e) {
                    routingContext.fail((Throwable)e);
                }
            }
        }, "Launch in IDE Action").start();
    }

    private boolean isNullOrEmpty(String arg) {
        return arg == null || arg.isEmpty();
    }
}

