/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.function.Predicate;

public interface QuarkusTestResourceLifecycleManager {
    public Map<String, String> start();

    public void stop();

    default public void setContext(Context context) {
    }

    default public void init(Map<String, String> initArgs) {
    }

    default public void inject(Object testInstance) {
    }

    default public void inject(TestInjector testInjector) {
    }

    default public int order() {
        return 0;
    }

    public static interface Context {
        public String testProfile();
    }

    public static interface TestInjector {
        public void injectIntoFields(Object var1, Predicate<Field> var2);

        public static class AnnotatedAndMatchesType
        implements Predicate<Field> {
            private final Class<? extends Annotation> annotationClass;
            private final Class<?> expectedFieldType;

            public AnnotatedAndMatchesType(Class<? extends Annotation> annotationClass, Class<?> expectedFieldType) {
                this.annotationClass = annotationClass;
                this.expectedFieldType = expectedFieldType;
            }

            @Override
            public boolean test(Field field) {
                if (field.getAnnotation(this.annotationClass) == null) {
                    return false;
                }
                return field.getType().isAssignableFrom(this.expectedFieldType);
            }
        }

        public static class Annotated
        implements Predicate<Field> {
            private final Class<? extends Annotation> annotationClass;

            public Annotated(Class<? extends Annotation> annotationClass) {
                this.annotationClass = annotationClass;
            }

            @Override
            public boolean test(Field field) {
                return field.getAnnotation(this.annotationClass) != null;
            }
        }
    }
}

