/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.common;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;

public class PropertyTestUtil {
    private static final String LOG_FILE_PATH_PROPERTY = "quarkus.log.file.path";

    public static void setLogFileProperty() {
        System.setProperty(LOG_FILE_PATH_PROPERTY, PropertyTestUtil.getLogFileLocation());
    }

    public static void setLogFileProperty(String logFileName) {
        System.setProperty(LOG_FILE_PATH_PROPERTY, PropertyTestUtil.getLogFileLocation(logFileName));
    }

    public static String getLogFileLocation() {
        return PropertyTestUtil.getLogFileLocation(PropertyTestUtil.getLogFinalName());
    }

    private static String getLogFinalName() {
        return System.getProperty(LOG_FILE_PATH_PROPERTY, "quarkus.log");
    }

    public static Path getLogFilePath() {
        List<String> logFileLocationParts = PropertyTestUtil.getLogFileLocationParts(PropertyTestUtil.getLogFinalName());
        if (logFileLocationParts.isEmpty()) {
            throw new IllegalStateException("Unable to determine log file path");
        }
        if (logFileLocationParts.size() == 1) {
            return Paths.get(logFileLocationParts.get(0), new String[0]);
        }
        return Paths.get(logFileLocationParts.get(0), logFileLocationParts.subList(1, logFileLocationParts.size()).toArray(new String[0]));
    }

    private static String getLogFileLocation(String logFileName) {
        return String.join((CharSequence)File.separator, PropertyTestUtil.getLogFileLocationParts(logFileName));
    }

    private static List<String> getLogFileLocationParts(String logFileName) {
        if (Files.isDirectory(Paths.get("build", new String[0]), new LinkOption[0])) {
            return Arrays.asList("build", logFileName);
        }
        return Arrays.asList("target", logFileName);
    }
}

