/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.spring.web.deployment;

import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.spring.web.deployment.AbstractExceptionMapperGenerator;
import javax.ws.rs.core.Response;
import org.jboss.jandex.ClassInfo;

class ResponseStatusOnExceptionGenerator
extends AbstractExceptionMapperGenerator {
    private final ClassInfo exceptionClassInfo;

    ResponseStatusOnExceptionGenerator(ClassInfo exceptionClassInfo, ClassOutput classOutput) {
        super(exceptionClassInfo.name(), classOutput);
        this.exceptionClassInfo = exceptionClassInfo;
    }

    @Override
    void generateMethodBody(MethodCreator toResponse) {
        ResultHandle status = toResponse.load(this.getHttpStatusFromAnnotation(this.exceptionClassInfo.classAnnotation(RESPONSE_STATUS)));
        ResultHandle responseBuilder = toResponse.invokeStaticMethod(MethodDescriptor.ofMethod(Response.class, (String)"status", Response.ResponseBuilder.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{status});
        ResultHandle exceptionMessage = toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod(Throwable.class, (String)"getMessage", String.class, (Class[])new Class[0]), toResponse.getMethodParam(0), new ResultHandle[0]);
        toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"entity", Response.ResponseBuilder.class, (Class[])new Class[]{Object.class}), responseBuilder, new ResultHandle[]{exceptionMessage});
        ResultHandle httpResponseType = toResponse.load("text/plain");
        toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"type", Response.ResponseBuilder.class, (Class[])new Class[]{String.class}), responseBuilder, new ResultHandle[]{httpResponseType});
        ResultHandle response = toResponse.invokeVirtualMethod(MethodDescriptor.ofMethod(Response.ResponseBuilder.class, (String)"build", Response.class, (Class[])new Class[0]), responseBuilder, new ResultHandle[0]);
        toResponse.returnValue(response);
    }
}

