/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime.devconsole;

import io.quarkus.arc.Arc;
import io.quarkus.devconsole.runtime.spi.DevConsolePostHandler;
import io.quarkus.devconsole.runtime.spi.FlashScopeUtil;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Trigger;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.ScheduledMethodMetadata;
import io.quarkus.scheduler.runtime.SchedulerContext;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.time.Instant;
import org.jboss.logging.Logger;

@Recorder
public class SchedulerDevConsoleRecorder {
    private static final Logger LOG = Logger.getLogger(SchedulerDevConsoleRecorder.class);

    public Handler<RoutingContext> invokeHandler() {
        final ClassLoader currentCl = Thread.currentThread().getContextClassLoader();
        return new DevConsolePostHandler(){

            protected void handlePost(RoutingContext event, MultiMap form) throws Exception {
                String name = form.get("name");
                final SchedulerContext context = (SchedulerContext)Arc.container().instance(SchedulerContext.class, new Annotation[0]).get();
                for (final ScheduledMethodMetadata metadata : context.getScheduledMethods()) {
                    if (!metadata.getMethodDescription().equals(name)) continue;
                    context.getExecutor().execute(new Runnable(){

                        @Override
                        public void run() {
                            ClassLoader previousCl = Thread.currentThread().getContextClassLoader();
                            try {
                                Thread.currentThread().setContextClassLoader(currentCl);
                                ScheduledInvoker invoker = context.createInvoker(metadata.getInvokerClassName());
                                invoker.invoke(new DevModeScheduledExecution());
                            }
                            catch (Exception e) {
                                LOG.error((Object)("Unable to invoke a @Scheduled method: " + metadata.getMethodDescription()), (Throwable)e);
                            }
                            finally {
                                Thread.currentThread().setContextClassLoader(previousCl);
                            }
                        }
                    });
                    this.flashMessage(event, "Action invoked");
                    return;
                }
                this.flashMessage(event, "Action not found: " + name, FlashScopeUtil.FlashMessageStatus.ERROR);
            }
        };
    }

    private static class DevModeScheduledExecution
    implements ScheduledExecution {
        private final Instant now = Instant.now();

        DevModeScheduledExecution() {
        }

        @Override
        public Trigger getTrigger() {
            return new Trigger(){

                @Override
                public String getId() {
                    return "dev-console";
                }

                @Override
                public Instant getNextFireTime() {
                    return null;
                }

                @Override
                public Instant getPreviousFireTime() {
                    return now;
                }
            };
        }

        @Override
        public Instant getFireTime() {
            return this.now;
        }

        @Override
        public Instant getScheduledFireTime() {
            return this.now;
        }
    }
}

