/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.runtime;

import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.SkippedExecution;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.enterprise.event.Event;
import org.jboss.logging.Logger;

public final class SkipConcurrentExecutionInvoker
implements ScheduledInvoker {
    private static final Logger LOGGER = Logger.getLogger(SkipConcurrentExecutionInvoker.class);
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final ScheduledInvoker delegate;
    private final Event<SkippedExecution> event;

    public SkipConcurrentExecutionInvoker(ScheduledInvoker delegate, Event<SkippedExecution> event) {
        this.delegate = delegate;
        this.event = event;
    }

    public void invoke(ScheduledExecution execution) throws Exception {
        if (this.running.compareAndSet(false, true)) {
            try {
                this.delegate.invoke(execution);
            }
            finally {
                this.running.set(false);
            }
        } else {
            LOGGER.debugf("Skipped scheduled invoker execution: %s", (Object)this.delegate.getClass().getName());
            SkippedExecution payload = new SkippedExecution(execution.getTrigger().getId(), execution.getFireTime());
            this.event.fire((Object)payload);
            this.event.fireAsync((Object)payload);
        }
    }

    public void invokeBean(ScheduledExecution param) {
        throw new UnsupportedOperationException();
    }
}

