/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.scheduler.deployment;

import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.deployment.AutoAddScopeBuildItem;
import io.quarkus.arc.deployment.BeanArchiveIndexBuildItem;
import io.quarkus.arc.deployment.BeanDiscoveryFinishedBuildItem;
import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.arc.deployment.TransformedAnnotationsBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.arc.deployment.ValidationPhaseBuildItem;
import io.quarkus.arc.processor.BeanInfo;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.arc.processor.DotNames;
import io.quarkus.arc.runtime.BeanLookupSupplier;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.AnnotationProxyBuildItem;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRouteBuildItem;
import io.quarkus.devconsole.spi.DevConsoleRuntimeTemplateInfoBuildItem;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.runtime.util.HashUtil;
import io.quarkus.scheduler.Scheduled;
import io.quarkus.scheduler.ScheduledExecution;
import io.quarkus.scheduler.Scheduler;
import io.quarkus.scheduler.deployment.ScheduledBusinessMethodItem;
import io.quarkus.scheduler.runtime.ScheduledInvoker;
import io.quarkus.scheduler.runtime.ScheduledMethodMetadata;
import io.quarkus.scheduler.runtime.SchedulerConfig;
import io.quarkus.scheduler.runtime.SchedulerContext;
import io.quarkus.scheduler.runtime.SchedulerRecorder;
import io.quarkus.scheduler.runtime.SimpleScheduler;
import io.quarkus.scheduler.runtime.devconsole.SchedulerDevConsoleRecorder;
import io.quarkus.scheduler.runtime.util.SchedulerUtils;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SchedulerProcessor {
    private static final Logger LOGGER = Logger.getLogger(SchedulerProcessor.class);
    static final DotName SCHEDULED_NAME = DotName.createSimple((String)Scheduled.class.getName());
    static final DotName SCHEDULES_NAME = DotName.createSimple((String)Scheduled.Schedules.class.getName());
    static final Type SCHEDULED_EXECUTION_TYPE = Type.create((DotName)DotName.createSimple((String)ScheduledExecution.class.getName()), (Type.Kind)Type.Kind.CLASS);
    static final String INVOKER_SUFFIX = "_ScheduledInvoker";
    static final String NESTED_SEPARATOR = "$_";

    @BuildStep
    void beans(Capabilities capabilities, BuildProducer<AdditionalBeanBuildItem> additionalBeans) {
        if (capabilities.isMissing("io.quarkus.quartz")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem(new Class[]{SimpleScheduler.class}));
        }
    }

    @BuildStep
    AutoAddScopeBuildItem autoAddScope() {
        return AutoAddScopeBuildItem.builder().containsAnnotations(new DotName[]{SCHEDULED_NAME, SCHEDULES_NAME}).defaultScope(BuiltinScope.SINGLETON).reason("Found scheduled business methods").build();
    }

    @BuildStep
    void collectScheduledMethods(BeanArchiveIndexBuildItem beanArchives, BeanDiscoveryFinishedBuildItem beanDiscovery, TransformedAnnotationsBuildItem transformedAnnotations, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods) {
        for (BeanInfo bean : beanDiscovery.beanStream().classBeans()) {
            this.collectScheduledMethods(beanArchives.getIndex(), transformedAnnotations, bean, ((AnnotationTarget)bean.getTarget().get()).asClass(), scheduledBusinessMethods);
        }
    }

    private void collectScheduledMethods(IndexView index, TransformedAnnotationsBuildItem transformedAnnotations, BeanInfo bean, ClassInfo beanClass, BuildProducer<ScheduledBusinessMethodItem> scheduledBusinessMethods) {
        ClassInfo superClass;
        for (MethodInfo method : beanClass.methods()) {
            List<AnnotationInstance> schedules = null;
            AnnotationInstance scheduledAnnotation = transformedAnnotations.getAnnotation((AnnotationTarget)method, SCHEDULED_NAME);
            if (scheduledAnnotation != null) {
                schedules = Collections.singletonList(scheduledAnnotation);
            } else {
                AnnotationInstance schedulesAnnotation = transformedAnnotations.getAnnotation((AnnotationTarget)method, SCHEDULES_NAME);
                if (schedulesAnnotation != null) {
                    schedules = new ArrayList<AnnotationInstance>();
                    for (AnnotationInstance scheduledInstance : schedulesAnnotation.value().asNestedArray()) {
                        schedules.add(AnnotationInstance.create((DotName)scheduledInstance.name(), (AnnotationTarget)schedulesAnnotation.target(), (List)scheduledInstance.values()));
                    }
                }
            }
            if (schedules == null) continue;
            scheduledBusinessMethods.produce((BuildItem)new ScheduledBusinessMethodItem(bean, method, schedules));
            LOGGER.debugf("Found scheduled business method %s declared on %s", (Object)method, (Object)bean);
        }
        DotName superClassName = beanClass.superName();
        if (superClassName != null && (superClass = index.getClassByName(superClassName)) != null) {
            this.collectScheduledMethods(index, transformedAnnotations, bean, superClass, scheduledBusinessMethods);
        }
    }

    @BuildStep
    void validateScheduledBusinessMethods(SchedulerConfig config, List<ScheduledBusinessMethodItem> scheduledMethods, ValidationPhaseBuildItem validationPhase, BuildProducer<ValidationPhaseBuildItem.ValidationErrorBuildItem> validationErrors) {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        HashMap<String, AnnotationInstance> encounteredIdentities = new HashMap<String, AnnotationInstance>();
        for (ScheduledBusinessMethodItem scheduledMethod : scheduledMethods) {
            MethodInfo method = scheduledMethod.getMethod();
            if (Modifier.isPrivate(method.flags()) || Modifier.isStatic(method.flags())) {
                errors.add(new IllegalStateException("@Scheduled method must be non-private and non-static: " + method.declaringClass().name() + "#" + method.name() + "()"));
                continue;
            }
            List params = method.parameters();
            if (params.size() > 1 || params.size() == 1 && !((Type)params.get(0)).equals((Object)SCHEDULED_EXECUTION_TYPE)) {
                errors.add(new IllegalStateException(String.format("Invalid scheduled business method parameters %s [method: %s, bean: %s]", params, method, scheduledMethod.getBean())));
            }
            if (!method.returnType().kind().equals((Object)Type.Kind.VOID)) {
                errors.add(new IllegalStateException(String.format("Scheduled business method must return void [method: %s, bean: %s]", method, scheduledMethod.getBean())));
            }
            CronParser parser = new CronParser(CronDefinitionBuilder.instanceDefinitionFor((CronType)config.cronType));
            for (AnnotationInstance scheduled : scheduledMethod.getSchedules()) {
                Throwable error = this.validateScheduled(parser, scheduled, encounteredIdentities);
                if (error == null) continue;
                errors.add(error);
            }
        }
        if (!errors.isEmpty()) {
            validationErrors.produce((BuildItem)new ValidationPhaseBuildItem.ValidationErrorBuildItem(errors));
        }
    }

    @BuildStep
    public List<UnremovableBeanBuildItem> unremovableBeans() {
        return Arrays.asList(new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULED_NAME)), new UnremovableBeanBuildItem((Predicate)new UnremovableBeanBuildItem.BeanClassAnnotationExclusion(SCHEDULES_NAME)));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public FeatureBuildItem build(SchedulerConfig config, BuildProducer<SyntheticBeanBuildItem> syntheticBeans, SchedulerRecorder recorder, List<ScheduledBusinessMethodItem> scheduledMethods, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, AnnotationProxyBuildItem annotationProxy, ExecutorBuildItem executor) {
        ArrayList<ScheduledMethodMetadata> scheduledMetadata = new ArrayList<ScheduledMethodMetadata>();
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClasses, (Function)new Function<String, String>(){

            @Override
            public String apply(String name) {
                int idx = name.indexOf(SchedulerProcessor.INVOKER_SUFFIX);
                if (idx != -1) {
                    name = name.substring(0, idx);
                }
                if (name.contains(SchedulerProcessor.NESTED_SEPARATOR)) {
                    name = name.replace(SchedulerProcessor.NESTED_SEPARATOR, "$");
                }
                return name;
            }
        });
        for (ScheduledBusinessMethodItem scheduledMethod : scheduledMethods) {
            ScheduledMethodMetadata metadata = new ScheduledMethodMetadata();
            String invokerClass = this.generateInvoker(scheduledMethod, (ClassOutput)classOutput);
            reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{invokerClass}));
            metadata.setInvokerClassName(invokerClass);
            ArrayList<Scheduled> schedules = new ArrayList<Scheduled>();
            for (AnnotationInstance scheduled : scheduledMethod.getSchedules()) {
                schedules.add((Scheduled)annotationProxy.builder(scheduled, Scheduled.class).build((ClassOutput)classOutput));
            }
            metadata.setSchedules(schedules);
            metadata.setMethodDescription(scheduledMethod.getMethod().declaringClass() + "#" + scheduledMethod.getMethod().name());
            scheduledMetadata.add(metadata);
        }
        syntheticBeans.produce((BuildItem)SyntheticBeanBuildItem.configure(SchedulerContext.class).setRuntimeInit().supplier(recorder.createContext(config, executor.getExecutorProxy(), scheduledMetadata)).done());
        return new FeatureBuildItem(Feature.SCHEDULER);
    }

    @BuildStep
    public void devConsoleInfo(BuildProducer<DevConsoleRuntimeTemplateInfoBuildItem> infos) {
        infos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("schedulerContext", (Supplier)new BeanLookupSupplier(SchedulerContext.class)));
        infos.produce((BuildItem)new DevConsoleRuntimeTemplateInfoBuildItem("scheduler", (Supplier)new BeanLookupSupplier(Scheduler.class)));
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT, optional=true)
    DevConsoleRouteBuildItem invokeEndpoint(SchedulerDevConsoleRecorder recorder) {
        return new DevConsoleRouteBuildItem("schedules", "POST", recorder.invokeHandler());
    }

    private String generateInvoker(ScheduledBusinessMethodItem scheduledMethod, ClassOutput classOutput) {
        BeanInfo bean = scheduledMethod.getBean();
        MethodInfo method = scheduledMethod.getMethod();
        Object baseName = bean.getImplClazz().enclosingClass() != null ? DotNames.simpleName((DotName)bean.getImplClazz().enclosingClass()) + NESTED_SEPARATOR + DotNames.simpleName((ClassInfo)bean.getImplClazz()) : DotNames.simpleName((DotName)bean.getImplClazz().name());
        StringBuilder sigBuilder = new StringBuilder();
        sigBuilder.append(method.name()).append("_").append(method.returnType().name().toString());
        for (Type i : method.parameters()) {
            sigBuilder.append(i.name().toString());
        }
        String generatedName = DotNames.internalPackageNameWithTrailingSlash((DotName)bean.getImplClazz().name()) + (String)baseName + "_ScheduledInvoker_" + method.name() + "_" + HashUtil.sha1((String)sigBuilder.toString());
        ClassCreator invokerCreator = ClassCreator.builder().classOutput(classOutput).className(generatedName).interfaces(new Class[]{ScheduledInvoker.class}).build();
        MethodCreator invoke = invokerCreator.getMethodCreator("invokeBean", Void.TYPE, new Class[]{Object.class}).addException(Exception.class);
        ResultHandle containerHandle = invoke.invokeStaticMethod(MethodDescriptor.ofMethod(Arc.class, (String)"container", ArcContainer.class, (Class[])new Class[0]), new ResultHandle[0]);
        ResultHandle beanHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"bean", InjectableBean.class, (Class[])new Class[]{String.class}), containerHandle, new ResultHandle[]{invoke.load(bean.getIdentifier())});
        ResultHandle instanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(ArcContainer.class, (String)"instance", InstanceHandle.class, (Class[])new Class[]{InjectableBean.class}), containerHandle, new ResultHandle[]{beanHandle});
        ResultHandle beanInstanceHandle = invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"get", Object.class, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        if (method.parameters().isEmpty()) {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[0]), beanInstanceHandle, new ResultHandle[0]);
        } else {
            invoke.invokeVirtualMethod(MethodDescriptor.ofMethod((Object)bean.getImplClazz().name().toString(), (String)method.name(), Void.TYPE, (Object[])new Object[]{ScheduledExecution.class}), beanInstanceHandle, new ResultHandle[]{invoke.getMethodParam(0)});
        }
        if (BuiltinScope.DEPENDENT.is(bean.getScope())) {
            invoke.invokeInterfaceMethod(MethodDescriptor.ofMethod(InstanceHandle.class, (String)"destroy", Void.TYPE, (Class[])new Class[0]), instanceHandle, new ResultHandle[0]);
        }
        invoke.returnValue(null);
        invokerCreator.close();
        return generatedName.replace('/', '.');
    }

    private Throwable validateScheduled(CronParser parser, AnnotationInstance schedule, Map<String, AnnotationInstance> encounteredIdentities) {
        AnnotationValue identityValue;
        MethodInfo method = schedule.target().asMethod();
        AnnotationValue cronValue = schedule.value("cron");
        AnnotationValue everyValue = schedule.value("every");
        if (cronValue != null && !cronValue.asString().trim().isEmpty()) {
            String cron = cronValue.asString().trim();
            if (!SchedulerUtils.isConfigValue((String)cron)) {
                try {
                    parser.parse(cron).validate();
                }
                catch (IllegalArgumentException e) {
                    return new IllegalStateException("Invalid cron() expression on: " + schedule, e);
                }
                if (everyValue != null && !everyValue.asString().trim().isEmpty()) {
                    LOGGER.warnf("%s declared on %s#%s() defines both cron() and every() - the cron expression takes precedence", (Object)schedule, (Object)method.declaringClass().name(), (Object)method.name());
                }
            }
        } else if (everyValue != null && !everyValue.asString().trim().isEmpty()) {
            Object every = everyValue.asString().trim();
            if (!SchedulerUtils.isConfigValue((String)every)) {
                if (Character.isDigit(((String)every).charAt(0))) {
                    every = "PT" + (String)every;
                }
                try {
                    Duration.parse((CharSequence)every);
                }
                catch (Exception e) {
                    return new IllegalStateException("Invalid every() expression on: " + schedule, e);
                }
            }
        } else {
            return new IllegalStateException("@Scheduled must declare either cron() or every(): " + schedule);
        }
        AnnotationValue delay = schedule.value("delay");
        AnnotationValue delayedValue = schedule.value("delayed");
        if (delay == null || delay.asLong() <= 0L) {
            Object delayed;
            if (delayedValue != null && !delayedValue.asString().trim().isEmpty() && !SchedulerUtils.isConfigValue((String)(delayed = delayedValue.asString().trim()))) {
                if (Character.isDigit(((String)delayed).charAt(0))) {
                    delayed = "PT" + (String)delayed;
                }
                try {
                    Duration.parse((CharSequence)delayed);
                }
                catch (Exception e) {
                    return new IllegalStateException("Invalid delayed() expression on: " + schedule, e);
                }
            }
        } else if (delayedValue != null && !delayedValue.asString().trim().isEmpty()) {
            LOGGER.warnf("%s declared on %s#%s() defines both delay() and delayed() - the delayed() value is ignored", (Object)schedule, (Object)method.declaringClass().name(), (Object)method.name());
        }
        if ((identityValue = schedule.value("identity")) != null) {
            String identity = SchedulerUtils.lookUpPropertyValue((String)identityValue.asString());
            AnnotationInstance previousInstanceWithSameIdentity = encounteredIdentities.get(identity);
            if (previousInstanceWithSameIdentity != null) {
                String message = String.format("The identity: \"%s\" on: %s is not unique and it has already bean used by : %s", identity, schedule, previousInstanceWithSameIdentity);
                return new IllegalStateException(message);
            }
            encounteredIdentities.put(identity, schedule);
        }
        return null;
    }
}

