/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.resteasy.deployment;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.IsDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.substrate.ReflectiveClassBuildItem;
import io.quarkus.resteasy.common.deployment.ResteasyJaxrsProviderBuildItem;
import io.quarkus.resteasy.deployment.ResteasyJaxrsConfigBuildItem;
import io.quarkus.resteasy.runtime.ExceptionMapperRecorder;
import io.quarkus.resteasy.runtime.NotFoundExceptionMapper;
import io.quarkus.resteasy.runtime.ResteasyFilter;
import io.quarkus.resteasy.runtime.RolesFilterRegistrar;
import io.quarkus.resteasy.server.common.deployment.ResteasyInjectionReadyBuildItem;
import io.quarkus.resteasy.server.common.deployment.ResteasyServerConfigBuildItem;
import io.quarkus.undertow.deployment.FilterBuildItem;
import io.quarkus.undertow.deployment.ServletBuildItem;
import io.quarkus.undertow.deployment.ServletInitParamBuildItem;
import io.quarkus.undertow.deployment.StaticResourceFilesBuildItem;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.DispatcherType;
import javax.ws.rs.core.Application;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;

public class ResteasyProcessor {
    private static final String JAVAX_WS_RS_APPLICATION;
    private static final String JAX_RS_FILTER_NAME;
    private static final String JAX_RS_SERVLET_NAME;

    @BuildStep
    public void jaxrsConfig(Optional<ResteasyServerConfigBuildItem> resteasyServerConfig, BuildProducer<ResteasyJaxrsConfigBuildItem> resteasyJaxrsConfig) {
        if (resteasyServerConfig.isPresent()) {
            resteasyJaxrsConfig.produce((BuildItem)new ResteasyJaxrsConfigBuildItem(resteasyServerConfig.get().getPath()));
        }
    }

    @BuildStep
    public void build(Optional<ResteasyServerConfigBuildItem> resteasyServerConfig, BuildProducer<FeatureBuildItem> feature, BuildProducer<FilterBuildItem> filter, BuildProducer<ServletBuildItem> servlet, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<ServletInitParamBuildItem> servletInitParameters, ResteasyInjectionReadyBuildItem resteasyInjectionReady) throws Exception {
        feature.produce((BuildItem)new FeatureBuildItem("resteasy"));
        if (resteasyServerConfig.isPresent()) {
            String path = resteasyServerConfig.get().getPath();
            if (path.equals("/") || path.isEmpty()) {
                filter.produce((BuildItem)FilterBuildItem.builder((String)JAX_RS_FILTER_NAME, (String)ResteasyFilter.class.getName()).setLoadOnStartup(1).addFilterServletNameMapping("default", DispatcherType.REQUEST).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{ResteasyFilter.class.getName()}));
            } else {
                String mappingPath = this.getMappingPath(path);
                servlet.produce((BuildItem)ServletBuildItem.builder((String)JAX_RS_SERVLET_NAME, (String)HttpServlet30Dispatcher.class.getName()).setLoadOnStartup(1).addMapping(mappingPath).setAsyncSupported(true).build());
                reflectiveClass.produce((BuildItem)new ReflectiveClassBuildItem(false, false, new String[]{HttpServlet30Dispatcher.class.getName()}));
            }
            for (Map.Entry initParameter : resteasyServerConfig.get().getInitParameters().entrySet()) {
                servletInitParameters.produce((BuildItem)new ServletInitParamBuildItem((String)initParameter.getKey(), (String)initParameter.getValue()));
            }
        }
    }

    @BuildStep
    void setupFilter(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(RolesFilterRegistrar.class.getName()));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    void setupExceptionMapper(BuildProducer<ResteasyJaxrsProviderBuildItem> providers) {
        providers.produce((BuildItem)new ResteasyJaxrsProviderBuildItem(NotFoundExceptionMapper.class.getName()));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void addServletsToExceptionMapper(List<ServletBuildItem> servlets, ExceptionMapperRecorder recorder) {
        recorder.setServlets(servlets.stream().filter(s -> !JAX_RS_SERVLET_NAME.equals(s.getName())).collect(Collectors.toMap(s -> s.getName(), s -> s.getMappings())));
    }

    @BuildStep(onlyIf={IsDevelopment.class})
    @Record(value=ExecutionTime.STATIC_INIT)
    void addStaticResourcesExceptionMapper(StaticResourceFilesBuildItem paths, ExceptionMapperRecorder recorder) {
        Set staticResources = paths.files.stream().filter(this::isHtmlFileName).limit(1000L).collect(Collectors.toSet());
        if (staticResources.isEmpty()) {
            staticResources = paths.files.stream().limit(1000L).collect(Collectors.toSet());
        }
        recorder.setStaticResource(staticResources);
    }

    private boolean isHtmlFileName(String fileName) {
        return fileName.endsWith(".html") || fileName.endsWith(".htm");
    }

    private String getMappingPath(String path) {
        String mappingPath = path.endsWith("/") ? path + "*" : path + "/*";
        return mappingPath;
    }

    static {
        JAX_RS_FILTER_NAME = JAVAX_WS_RS_APPLICATION = Application.class.getName();
        JAX_RS_SERVLET_NAME = JAVAX_WS_RS_APPLICATION;
    }
}

