/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import java.util.Objects;

public interface ValueRegistry {
    public <T> void register(RuntimeKey<T> var1, T var2);

    public <T> void registerInfo(RuntimeKey<T> var1, RuntimeInfo<T> var2);

    public <T> T get(RuntimeKey<T> var1);

    public <T> T getOrDefault(RuntimeKey<T> var1, T var2);

    public <T> boolean containsKey(RuntimeKey<T> var1);

    @Deprecated(forRemoval=true)
    public RuntimeInfo<?> get(String var1);

    public static final class RuntimeKey<T> {
        private final String key;
        private final Class<T> type;

        RuntimeKey(String key) {
            this(key, String.class);
        }

        RuntimeKey(String key, Class<T> type) {
            this.key = key;
            this.type = type;
        }

        public String key() {
            return this.key;
        }

        public Class<T> type() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (!(o instanceof RuntimeKey)) {
                return false;
            }
            RuntimeKey that = (RuntimeKey)o;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hashCode(this.key);
        }

        public static <T> RuntimeKey<T> key(String key) {
            return new RuntimeKey<T>(key);
        }

        public static <T> RuntimeKey<T> key(String key, Class<T> type) {
            return new RuntimeKey<T>(key, type);
        }

        public static <T> RuntimeKey<T> key(Class<T> type) {
            return new RuntimeKey<T>(type.getName(), type);
        }

        public static RuntimeKey<Integer> intKey(String key) {
            return new RuntimeKey<Integer>(key, Integer.class);
        }

        public static RuntimeKey<Boolean> booleanKey(String key) {
            return new RuntimeKey<Boolean>(key, Boolean.class);
        }
    }

    public static interface RuntimeInfo<T> {
        public T get(ValueRegistry var1);

        public static class SimpleRuntimeInfo<T>
        implements RuntimeInfo<T> {
            private final T value;

            SimpleRuntimeInfo(T value) {
                this.value = value;
            }

            @Override
            public T get(ValueRegistry valueRegistry) {
                return this.value;
            }

            public static <T> SimpleRuntimeInfo<T> of(T value) {
                return new SimpleRuntimeInfo<T>(value);
            }
        }
    }
}

