/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.mutiny.runtime;

import io.quarkus.runtime.annotations.Recorder;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import org.jboss.logging.Logger;

@Recorder
public class MutinyInfrastructure {
    public static final String VERTX_EVENT_LOOP_THREAD_PREFIX = "vert.x-eventloop-thread-";

    public void configureMutinyInfrastructure(final ExecutorService exec) {
        Infrastructure.setDefaultExecutor((Executor)new Executor(){

            @Override
            public void execute(Runnable command) {
                block2: {
                    try {
                        exec.execute(command);
                    }
                    catch (RejectedExecutionException e) {
                        if (exec.isShutdown() || exec.isTerminated()) break block2;
                        throw e;
                    }
                }
            }
        });
    }

    public void configureDroppedExceptionHandlerAndThreadBlockingChecker() {
        final Logger logger = Logger.getLogger(MutinyInfrastructure.class);
        Infrastructure.setDroppedExceptionHandler((Consumer)new Consumer<Throwable>(){

            @Override
            public void accept(Throwable throwable) {
                logger.error((Object)"Mutiny had to drop the following exception", throwable);
            }
        });
        Infrastructure.setCanCallerThreadBeBlockedSupplier((BooleanSupplier)new BooleanSupplier(){

            @Override
            public boolean getAsBoolean() {
                String threadName = Thread.currentThread().getName();
                return !threadName.startsWith(MutinyInfrastructure.VERTX_EVENT_LOOP_THREAD_PREFIX);
            }
        });
    }
}

