/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.test.junit;

import io.quarkus.test.junit.QuarkusTestProfile;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

final class TestProfileAndProperties {
    private final QuarkusTestProfile testProfile;
    private final Map<String, String> properties;

    TestProfileAndProperties(QuarkusTestProfile testProfile, Map<String, String> properties) {
        this.testProfile = testProfile;
        this.properties = properties != null ? properties : Collections.emptyMap();
    }

    public Optional<QuarkusTestProfile> testProfile() {
        return Optional.ofNullable(this.testProfile);
    }

    Map<String, String> properties() {
        return Collections.unmodifiableMap(this.properties);
    }

    Optional<String> configProfile() {
        return this.testProfile().map(QuarkusTestProfile::getConfigProfile);
    }

    boolean isDisabledGlobalTestResources() {
        return this.testProfile().map(QuarkusTestProfile::disableGlobalTestResources).orElse(false);
    }

    Optional<String> testProfileClassName() {
        return this.testProfile().map(testProfile -> testProfile.getClass().getName());
    }
}

