/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.jdbc.postgresql.deployment;

import io.quarkus.agroal.spi.JdbcDriverBuildItem;
import io.quarkus.arc.deployment.AdditionalBeanBuildItem;
import io.quarkus.arc.processor.BuiltinScope;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.datasource.deployment.spi.DefaultDataSourceDbKindBuildItem;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceConfigurationHandlerBuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.SslNativeConfigBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ServiceProviderBuildItem;
import io.quarkus.jdbc.postgresql.runtime.PostgreSQLAgroalConnectionConfigurer;
import io.quarkus.jdbc.postgresql.runtime.PostgreSQLServiceBindingConverter;

public class JDBCPostgreSQLProcessor {
    @BuildStep
    FeatureBuildItem feature() {
        return new FeatureBuildItem(Feature.JDBC_POSTGRESQL);
    }

    @BuildStep
    void registerDriver(BuildProducer<JdbcDriverBuildItem> jdbcDriver, SslNativeConfigBuildItem sslNativeConfigBuildItem) {
        jdbcDriver.produce((BuildItem)new JdbcDriverBuildItem("postgresql", "org.postgresql.Driver", "org.postgresql.xa.PGXADataSource"));
    }

    @BuildStep
    DevServicesDatasourceConfigurationHandlerBuildItem devDbHandler() {
        return DevServicesDatasourceConfigurationHandlerBuildItem.jdbc((String)"postgresql");
    }

    @BuildStep
    void configureAgroalConnection(BuildProducer<AdditionalBeanBuildItem> additionalBeans, Capabilities capabilities) {
        if (capabilities.isPresent("io.quarkus.agroal")) {
            additionalBeans.produce((BuildItem)new AdditionalBeanBuildItem.Builder().addBeanClass(PostgreSQLAgroalConnectionConfigurer.class).setDefaultScope(BuiltinScope.APPLICATION.getName()).setUnremovable().build());
        }
    }

    @BuildStep
    void registerServiceBinding(Capabilities capabilities, BuildProducer<ServiceProviderBuildItem> serviceProvider, BuildProducer<DefaultDataSourceDbKindBuildItem> dbKind) {
        if (capabilities.isPresent("io.quarkus.kubernetes.service.binding")) {
            serviceProvider.produce((BuildItem)new ServiceProviderBuildItem("io.quarkus.kubernetes.service.binding.runtime.ServiceBindingConverter", new String[]{PostgreSQLServiceBindingConverter.class.getName()}));
        }
        dbKind.produce((BuildItem)new DefaultDataSourceDbKindBuildItem("postgresql"));
    }
}

